(ns backend-shared.converters.github
  (:require [shared.models.course.index :as course]
            [clojure.walk :as walk]
            [cljs.nodejs :as node]))

(def atob (node/require "atob"))
(def yaml (node/require "js-yaml"))

(defn yaml-file? [{:keys [path] :as ref}]
  (re-find #"\.yaml$" path))

(defn yaml->json [input]
  (.safeLoad yaml input))

(defn ->items [{:keys [curator repo]}]
  (->> (:tree repo)
       (filterv yaml-file?)
       (map #(assoc %1 :curator curator))))

(defn ->course [{:keys [repo-item curator] :as repo-item}]
  (-> (:content repo-item)
      atob
      yaml->json
      js->clj
      walk/keywordize-keys
      (assoc :curator curator)
      course/initialize))
