(ns backend-shared.aws-event.index
  (:require [backend-shared.aws-event.to-action :refer [to-action]]
            [backend-shared.aws-event.to-credentials :refer [to-credentials]]
            [backend-shared.aws-event.to-db-events :refer [to-db-events]]
            [backend-shared.aws-event.to-payload :refer [to-payload]]
            [backend-shared.aws-event.to-query :refer [to-query]]
            [shared.protocols.convertible :as cv :refer [Convertible]]
            [shared.protocols.loggable :as log]
            [clojure.string :as str]))

(defrecord AwsEvent []
  Convertible
  (-to-credentials [this] (to-credentials this))
  (-to-query [this]       (to-query this))
  (-to-action [this]      (to-action this))
  (-to-db-events [this]   (to-db-events this))
  (-to-payload [this]     (to-payload this)))


(defn create [raw-event]
  (let [auth-id (-> raw-event :requestContext :authorizer :principalId)
        [provider user-name] (str/split auth-id "|")
        user (when (= "offcourse" provider) {:user-name user-name})
        guest (when-not (= "offcourse" provider) {:auth-id auth-id})]
  (-> raw-event
      (assoc :user user
             :guest guest)
      map->AwsEvent
      (with-meta {:spec :aws/event}))))
