(ns backend-adapters.es.perform
  (:require [cljs.core.async :refer [<! into merge]]
            [backend-adapters.es.impl.save :refer [save]]
            [shared.models.error.index :as error]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn to-search [{:keys [course-id] :as item} index-name]
  {:id course-id
   :item item
   :index-name :courses})

(defn perform [{:keys [endpoint-url instance] :as this} [_ payload]]
  (go
    (let [queries     (mapv to-search payload)
          query-chans (merge (map #(save instance % endpoint-url) queries))
          merged-res  (<! (into [] query-chans))]
      (log/log "MR" (clj->js merged-res))
      merged-res
      #_(if (empty? errors)
          [:saved success]
          [:failed (error/create :es-error errors)]))))
