(ns backend-adapters.es.index
  (:require [backend-adapters.es.fetch :refer [fetch]]
            [backend-adapters.es.perform :refer [perform]]
            [cljs.nodejs :as node]
            [shared.protocols.actionable :refer [Actionable]]
            [shared.protocols.queryable :refer [Queryable]]))

(def -request (node/require "request"))
(def request (.defaults -request
                        (clj->js {})))

(def AWS (node/require "aws-sdk"))

(defn create [{:keys [index-names search-url]}]
  (specify! {:instance request

             :endpoint-url search-url
             :endpoint (when search-url (AWS.Endpoint. search-url))
             :url search-url}
    Queryable
    (-fetch [this query] (fetch this query))
    Actionable
    (-perform [this action] (perform this action))))
