(ns backend-shared.specs.github
  (:require [cljs.spec.alpha :as spec]))

(spec/def ::owner string?)
(spec/def ::name string?)
(spec/def ::mode string?)
(spec/def ::content string?)
(spec/def ::type string?)
(spec/def ::size int?)
(spec/def ::sha string?)
(spec/def ::path string?)
(spec/def ::encoding string?)
(spec/def ::tree (spec/* map?))

(spec/def ::commit-sha ::sha)
(spec/def ::repo-name ::name)
(spec/def ::curator :base/user-name)

(spec/def :github/repo (spec/keys :req-un [::sha
                                           ::tree
                                           :base/url]))

(spec/def :github/repo-item (spec/keys :req-un [::sha
                                                ::size
                                                :base/url
                                                ::content
                                                ::encoding]))

(spec/def :github/repo-query (spec/keys :req-un [::repo-name
                                                 ::commit-sha
                                                 ::owner
                                                 ::curator]
                                        :opt-un [:github/repo]))

(spec/def :github/item-query (spec/keys :req-un [::path
                                                 ::sha
                                                 :base/url
                                                 ::curator]
                                        :opt-un [:github/repo-item]))
