(ns backend-shared.service.perform
  (:require [shared.protocols.specced :as sp]
            [backend-shared.converters.index :refer [compressed->clj clj->compressed]]
            [shared.protocols.loggable :as log]
            [cljs.core.async :as async :refer [<!]]
            [shared.models.event.index :as event]
            [shared.models.error.index :as error])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action]
                    (sp/resolve action)))

(defmethod perform [:compress :resource] [_ [_ payload]]
  (event/create [:compressed {:compressed-data (clj->compressed payload)}]))

(defmethod perform [:compress :raw-resource] [_ [_ payload]]
  (event/create [:compressed {:compressed-data (clj->compressed payload)}]))

(defmethod perform [:compress :error] [_ [_ error]]
  (event/create [:failed error]))

(defmethod perform [:deflate :compressed-data] [_ [_ payload]]
  (event/create [:deflated (compressed->clj payload)]))

(defmethod perform :invalid-action [_ action]
  (event/create [:failed (error/create :invalid-action action)]))
