(ns backend-shared.protocol_extensions.convertible
  (:require [shared.protocols.convertible :as cv :refer [Convertible]]
            [clojure.string :as str]
            [cljs.spec.alpha :as spec]))

(extend-protocol Convertible
  nil
  (-to-clj [_]                  nil)
  array
  (-to-clj [js-arr]             (js->clj js-arr :keywordize-keys true))
  object
  (-to-clj [js-obj]             (js->clj js-obj :keywordize-keys true))
  (-to-json     [obj]           (->> obj clj->js (.stringify js/JSON)))
  string
  (-to-clj [string]             (->> string (.parse js/JSON) cv/to-clj))
  PersistentHashMap
  (-to-json     [obj]           (->> obj clj->js (.stringify js/JSON)))
  PersistentArrayMap
  (-to-json     [obj]           (->> obj clj->js (.stringify js/JSON)))
  LazySeq
  (-to-json     [obj]           (->> obj clj->js (.stringify js/JSON)))
  PersistentVector
  (-to-json     [obj]           (->> obj clj->js (.stringify js/JSON))))
