(ns backend-adapters.mercury.fetch
  (:require [cljs.core.async :as async]
            [cljs.nodejs :as node]
            [shared.models.payload.index :as payload]
            [shared.protocols.loggable :as log]
            [clojure.string :as str]
            [shared.protocols.convertible :as cv]
            [shared.models.event.index :as event]
            [shared.models.error.index :as error])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def request (node/require "request"))

(defn create-url [endpoint api-key url]
  (str endpoint "/parser?url=" url))

(defn handle-response [channel error res data]
  (let [status-code                    (aget res "statusCode")
        {:keys [error_code] :as body} (cv/to-clj data)
        error                         (when (or error error_code (>= status-code 400)) (error/create :mercury-error res))
        data                          (when-not error (-> body cv/to-clj))]
    (async/put! channel (if error (event/create [:failed error]) (event/create [:found data])))
    (async/close! channel)))

(defn fetch [{:keys [endpoint error api-key] :as this} {:keys [resource-url]}]
  (let [c (async/chan)]
    (go
      (request (clj->js {:url (str endpoint "/parser?url=" resource-url)
                         :headers {:x-api-key api-key}})
               #(handle-response c %1 %2 %3)))
      c))
