(ns backend-adapters.index
  (:require [backend-adapters.auth0.index :as auth0]
            [backend-adapters.dynamodb.index :as dynamodb]
            [backend-adapters.mercury.index :as mercury]
            [backend-adapters.es.index :as es]
            [backend-adapters.github.index :as github]
            [backend-adapters.http.index :as http]
            [backend-adapters.iam.index :as iam]
            [backend-adapters.kinesis.index :as kinesis]
            [backend-adapters.s3.index :as s3]
            [backend-adapters.stepfunctions.index :as stepfunctions]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]))

(def constructors {:db            #(dynamodb/create %)
                   :state-machine #(stepfunctions/create %)
                   :http          #(http/create %)
                   :auth          #(auth0/create %)
                   :iam           #(iam/create %)
                   :index         #(es/create %)
                   :bucket        #(s3/create %)
                   :stream        #(kinesis/create %)})

(defn check [[key val]] (if-not val key (when (map? val) (keep check val))))

(defn create [adapters]
  (reduce (fn [acc [adapter-name config]]
            (let [errors (flatten (keep check config))]
              (if-not (empty? errors)
                (assoc acc adapter-name ((adapter-name constructors) {:error (error/create :missing-env-var adapter-name)}))
                (assoc acc adapter-name ((adapter-name constructors) config)))))
          {} adapters))
