(ns backend-shared.service.respond.index
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]
            [cljs.spec.alpha :as spec]
            [backend-shared.converters.index :refer [response->api]]
            [shared.models.payload.index :as payload]
            [shared.models.error.index :as error]))

(defmulti respond (fn [_ event]
                    (if (sp/resolve event) (sp/resolve event) :invalid-event)))

(defmethod respond [:failed :error] [{:keys [callback is_endpoint? event] :as service} [event-type error]]
  (let [error (merge error {:service-name (:service-name service)
                            :stage        (:stage service)
                            :event        event})]
    (if is_endpoint?
      (callback nil (clj->js (response->api [event-type error])))
      (callback (.stringify js/JSON (clj->js error))))))

(defmethod respond :invalid-event [{:keys [callback is_endpoint? event] :as service} [event-type :as event]]
  (let [error (-> (error/create :invalid-event event)
                  (merge {:service-name (:service-name service)
                          :stage        (:stage service)
                          :event        event}))]
    (if is_endpoint?
      (callback nil (clj->js (response->api [event-type error])))
      (callback (.stringify js/JSON (clj->js error))))))

(defmethod respond :default [{:keys [callback is_endpoint?]} [_ payload :as event]]
  (if is_endpoint?
    (callback nil (clj->js (response->api event)))
    (callback nil (clj->js payload))))
