(ns backend-adapters.dynamodb.impl.query
  (:require [shared.models.event.index :as event]
            [shared.protocols.convertible :as cv]
            [cljs.core.async :refer [chan close! put!]]
            [shared.models.error.index :as error]
            [shared.protocols.loggable :as log])
(:require-macros [cljs.core.async.macros :refer [go]]))

(defn handle-success [res]
  (if-let [item (-> res cv/to-clj :Items first)]
    (event/create [:found item])
    (event/create [:not-found res])))

(defn handle-error [error]
  (event/create [:failed (error/create :dynamodb-error error)]))

(defn- handle-response [c error res]
  (go
    (if error
      (put! c (handle-error error))
      (put! c (handle-success res)))
    (close! c)))

(defn query [instance query]
  (let [c (chan)]
    (.query instance (clj->js query) #(handle-response c %1 %2))
    c))
