(ns backend-adapters.dynamodb.impl
  (:refer-clojure :exclude [update])
  (:require [shared.models.error.index :as error]
            [cljs.core.async :as async]))

(defn put [{:keys [instance] :as adapter} query]
  (let [c (async/chan)]
    (.put instance (clj->js query) #(-handle-response c %1 %2))
    c))

(defn batch-put [{:keys [instance] :as adapter} query]
  (let [c (async/chan)]
    (.batchWrite instance (clj->js query) #(-handle-response c %1 %2))
    c))

(defn update [{:keys [instance] :as adapter} query]
  (let [c (async/chan)]
    (.update instance (clj->js query) #(-handle-response c %1 %2))
    c))

;; (defmethod perform :update [{:keys [table-names] :as this} [_ payload]]
;;   (let [{:keys [course-id revision checkpoint-index tags resource-url]} payload
;;         payload-type (sp/resolve payload)
;;         table-name (payload-type table-names)
;;         delta {:TableName table-name
;;                :Key {:course-id course-id
;;                      :revision revision}
;;                :UpdateExpression (str "SET #cp[" checkpoint-index "].#tf = :t, #cp[" checkpoint-index "].#uf = :u")
;;                :ExpressionAttributeNames {"#cp" "checkpoints"
;;                                           "#tf" "tags"
;;                                           "#uf" "resource-url"}
;;                :ExpressionAttributeValues {":t" tags
;;                                            ":u" resource-url}
;;                :ReturnValues "ALL_NEW"}]
;;     (impl/update this delta)))

;; (defn save-many [{:keys [table-names] :as this} payload]
;;   (let [payload-type (sp/resolve payload)
;;         table-name (payload-type table-names)
;;         items (map (fn [item] {:PutRequest {:Item (-> item replaceEmptyStrings clj->js)}}) payload)
;;         query {:RequestItems {table-name items}}]
;;     (impl/batch-put this query)))
