(ns backend-shared.service.fetch
  (:require [shared.protocols.queryable :as qa]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp]
            [shared.models.error.index :as error])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti fetch (fn [_ query] (sp/resolve query)))

(defmethod fetch :invalid-query [_ query]
  (go
    [:failed (error/create :invalid-query query)]))
