(ns backend-adapters.s3.specs
  (:require [cljs.spec.alpha :as spec]))

(spec/def :s3-adapter/query (spec/or :raw-resource :bookmark/augmented
                                     :resource   :query/resource))

(defmulti action-spec (fn [[action-type _ :as action]] action-type))

(spec/def :s3-adapter/action (spec/multi-spec action-spec :action-type))

(defmethod action-spec :save [_]
  (spec/tuple :offcourse/actions (spec/or :raw-user           :raw/user
                                          :repo-items         (spec/coll-of :github/item-query)
                                          :resource           :offcourse/resource
                                          :augmented-bookmark :bookmark/augmented
                                          :raw-resource       :raw/resource
                                          :portrait           :offcourse/portrait
                                          :bookmarks          (spec/coll-of :offcourse/bookmark))))

