(ns backend-adapters.s3.perform
  (:require [backend-adapters.s3.impl.save :refer [save]]
            [backend-adapters.s3.converters.to-action :refer [to-action]]
            [cljs.core.async :refer [<!]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti perform (fn [service action] (sp/resolve action)))

(defmethod perform :default [{:keys [converters] :as this} [_ payload :as action]]
  (go
    (let [action-query       (to-action this action)
          [res-type :as res] (<! (save this action-query))]
      (if (= res-type :saved)
        (event/create [:saved payload])
        res))))

(defmethod perform :invalid-action [_ action]
  (go (event/create [:failed (error/create :s3-unsupported-action action)])))
