(ns backend-adapters.s3.fetch
  (:require [backend-adapters.s3.impl.get :refer [get]]
            [backend-adapters.s3.converters.to-query :refer [to-query]]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defmulti fetch (fn [_ query]
                  (sp/resolve query)))

(defmethod fetch :default [{:keys [instance bucket-names]} query]
  (get instance (to-query query bucket-names)))

(defmethod fetch :invalid-query [_ query]
  (go (event/create [:failed (error/create :s3-unsupported-query query)])))

#_(defn fetch
    ([{:keys [instance] :as adapter} credentials query]
     (.update instance.config (clj->js (assoc credentials :signatureVersion "v4")))
     (fetch adapter query)))
