(ns backend-shared.specs.bookmark
  (:require [cljs.spec.alpha :as spec]))

(spec/def ::missing #{:not-found "not-found"})
(spec/def :missing/resource ::missing)
(spec/def :missing/course ::missing)

(spec/def :bookmark/missing-course   (spec/keys :req-un [:resource/resource-url
                                                         :base/timestamp
                                                         :bookmark/source
                                                         :offcourse/resource
                                                         :missing/course]))

(spec/def :bookmark/missing-resource (spec/keys :req-un [:resource/resource-url
                                                         :base/timestamp
                                                         :bookmark/source
                                                         :offcourse/course
                                                         :missing/resource]))

(spec/def ::compressed-data string?)
(spec/def :zipped/resource (spec/keys :req-un [::compressed-data]))

(spec/def :bookmark/compressed-resource  (spec/keys :req-un [:resource/resource-url
                                                             :base/timestamp
                                                             :bookmark/source
                                                             :zipped/resource
                                                             :offcourse/course]))

(spec/def :bookmark/complete         (spec/keys :req-un [:resource/resource-url
                                                         :base/timestamp
                                                         :bookmark/source
                                                         :offcourse/resource
                                                         :offcourse/course]))

(spec/def :bookmark/augmented        (spec/or :missing-course :bookmark/missing-course
                                              :missing-resource :bookmark/missing-resource
                                              :complete :bookmark/complete))
