(ns backend-adapters.s3.converters.to-query
  (:require [backend-shared.crypto :as crypto]
            [shared.protocols.specced :as sp]))

(defn ->s3 [bucket-name {:keys [key]}]
  {:Bucket bucket-name
   :Key key})

(defmulti to-query (fn [query _] (sp/resolve query)))

(defmethod to-query :resource [{:keys [resource-url]} bucket-names]
  {:Bucket (:resource bucket-names)
   :Key (str (crypto/hasher resource-url) ".json")})

(defmethod to-query :raw-resource [{:keys [resource-url]} bucket-names]
  {:Bucket (:resource bucket-names)
   :Key (str (crypto/hasher resource-url) ".json")})
