(ns backend-adapters.dynamodb.fetch
  (:refer-clojure :exclude [get])
  (:require [backend-adapters.dynamodb.to-query :refer [to-query]]
            [cljs.core.async :refer [<! chan close! put!]]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]
            [shared.models.event.index :as event])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn exec-query [instance query]
  (let [c (chan)]
    (.query instance (clj->js query) #(let [response (if %1
                                                       (event/create [:failed (error/create :db-error %1)])
                                                       (if-let [item (-> %2 cv/to-clj :Items first)]
                                                         (event/create [:found item])
                                                         (event/create [:not-found query])))]
                                        (put! c response)
                                        (close! c)))
    c))

(defn fetch [{:keys [instance table-names] :as adapter} query]
  (go
    (let [query (to-query query table-names)
          res  (<! (exec-query instance query))]
      res)))
