(ns backend-shared.specs.index
  (:require [cljs.spec.alpha :as spec]
            [shared.specs.index]
            [backend-shared.specs.bookmark]
            [backend-shared.specs.raw]
            [backend-shared.specs.aws.index]
            [backend-shared.specs.github]
            [backend-shared.specs.mercury]
            [backend-shared.specs.embedly]))

(spec/def :offcourse/action  :action/valid)
(spec/def :offcourse/event   :event/valid)

(spec/def :checkpoint/index int?)
(spec/def :checkpoint/update (spec/keys :req-un [:course/course-id
                                                  :course/revision
                                                  :checkpoint/checkpoint-id
                                                  :resource/resource-url
                                                  ::checkpoint-index
                                                  :base/tags]))


(spec/def ::compressed-data string?)
(spec/def :offcourse/compressed (spec/keys :req-un [::compressed-data]))

(spec/def :raw/user-data (spec/keys :req-un [:offcourse/profile
                                             :offcourse/portrait
                                             :offcourse/identities]))
