(ns backend-adapters.auth0.perform
  (:require [cljs.core.async :as async]
            [cljs.nodejs :as node]
            [shared.protocols.convertible :as cv]
            [shared.protocols.loggable :as log]
            [shared.models.error.index :as error]))

(def jwt  (node/require "jsonwebtoken"))


(defn perform [{:keys [secret]} [_ {:keys [auth-token]}]]
  (let [c  (async/chan)]
    (if secret
      (.verify jwt auth-token (str secret)
               #(async/put! c (if %1
                                [:failed (error/create :auth-error %1)]
                                [:found (when %2 (:sub (cv/to-clj %2)))])))
      (async/put! c {:error "auth secret should be set in the environment"}))
    c))
