(ns backend-shared.service.perform
  (:require [shared.protocols.specced :as sp]
            [cljs.core.async :as async :refer [<!]]
            [shared.protocols.loggable :as log]
            [clojure.nodejs :as node]
            [shared.protocols.convertible :as cv]
            [cljs.spec.alpha :as spec]
            [shared.models.error.index :as error])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def Zip (node/require "node-zip"))

(def zip-key :data)

(defmulti perform (fn [service action]
                    (sp/resolve action)))

(defn compress [payload]
  (-> (new Zip)
      (.file (name zip-key) (.stringify js/JSON (clj->js payload)))
      (.generate (clj->js {:base64 true :compression :DEFLATE}))))

(defmethod perform [:compress :resource] [_ [_ payload]]
  [:compressed {:compressed-data (compress payload)}])

(defmethod perform [:compress :raw-resource] [_ [_ payload]]
  [:compressed {:compressed-data (compress payload)}])

(defmethod perform [:compress :error] [_ [_ error]]
  [:failed error])

(defmethod perform [:deflate :compressed-data] [_ [_ payload]]
  [:deflated (-> (new Zip (:compressed-data payload) (clj->js {:base64 true :checkCRC32 true}))
                 cv/to-clj
                 (get-in [:files zip-key :_data])
                 cv/to-clj)])

(defmethod perform :invalid-action [_ action]
  (go
    [:failed (error/create :invalid-action action)]))
