(ns backend-adapters.dynamodb.impl
  (:refer-clojure :exclude [update])
  (:require [shared.models.error.index :as error]
            [cljs.core.async :as async]))

(defn -handle-response [channel error payload]
  (let [response (if error
                   [:failed (error/create :dynamodb-error error)]
                   [:success payload])]
    (async/put! channel response)
    (async/close! channel)))

(defn put [{:keys [instance] :as adapter} query]
  (let [c (async/chan)]
    (.put instance (clj->js query) #(-handle-response c %1 %2))
    c))

(defn update [{:keys [instance] :as adapter} query]
  (let [c (async/chan)]
    (.update instance (clj->js query) #(-handle-response c %1 %2))
    c))
