(ns backend-shared.models.payload.to-resource.mercury
  (:require [backend-shared.models.payload.to-resource.tags :refer [html->tags]]
            [backend-shared.models.payload.to-resource.helpers :refer [determine-type video-content]]
            [shared.models.resource.index :as rs]
            [shared.protocols.loggable :as log]
            [cljs.nodejs :as node]))

(defmulti to-resource (fn [{:keys [url]}] (determine-type url)))

(defmethod to-resource :video [{:keys [url title excerpt content]}]
  (let [record {:resource-url  url
                :title         title
                :resource-type (determine-type url)
                :content       (video-content url)
                :description   excerpt
                :tags          (html->tags content)}]
    (rs/create (into {} (remove (comp nil? second) record)))))

(defmethod to-resource :html [{:keys [url title excerpt content]}]
  (let [record {:resource-url  url
                :title         title
                :resource-type (determine-type url)
                :content       content
                :description   excerpt
                :tags          (html->tags content)}]
    (rs/create (into {} (remove (comp nil? second) record)))))

