(ns backend-shared.models.payload.to-user-data
  (:require [shared.protocols.loggable :as log]))

(defn extract-auth-id [{:keys [provider user_id]}]
  (str provider "|" user_id))

(defn to-profile [{:keys [profile auth-profile]}]
  (-> auth-profile
      (dissoc :identities :picture)
      (assoc :user-name (:user-name profile)
             :revision 1)))

(defn to-identity [auth-identity user-name]
  {:auth-id (extract-auth-id auth-identity)
   :user-name user-name})

(defn to-portrait [{:keys [profile auth-profile]}]
  {:portrait-url (str (:picture auth-profile) "&s=300")
   :user-name (:user-name profile)})

(defn to-identities [{:keys [auth-profile profile]}]
  (map #(to-identity %1 (:user-name profile)) (:identities auth-profile)))

(defn to-user-data [payload]
  {:profile (to-profile payload)
   :portrait (to-portrait payload)
   :identities (to-identities payload)})
