(ns backend-shared.models.payload.to-course-update
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]))

(defn find-checkpoint-index [checkpoints checkpoint-id]
  (->> checkpoints
       (map-indexed vector)
       (filter #(= (:checkpoint-id (second %)) checkpoint-id))
       first
       first))

(defmulti to-course-update
  #(sp/resolve %1))

(defmethod to-course-update :augmented-bookmark [{:keys [source course resource] :as bookmark}]
  (let [{:keys [checkpoint-id]} source
        {:keys [checkpoints]} course
        {:keys [resource-url tags]} resource]
    (assoc source
           :resource-url resource-url
           :checkpoint-index (find-checkpoint-index checkpoints checkpoint-id)
           :tags (take 3 (into #{} tags)))))
