(ns backend-adapters.index
  (:require [backend-adapters.auth0.index :as auth0]
            [backend-adapters.dynamodb.index :as dynamodb]
            [backend-adapters.embedly.index :as embedly]
            [backend-adapters.mercury.index :as mercury]
            [backend-adapters.es.index :as es]
            [backend-adapters.github.index :as github]
            [backend-adapters.http.index :as http]
            [backend-adapters.iam.index :as iam]
            [backend-adapters.kinesis.index :as kinesis]
            [backend-adapters.s3.index :as s3]
            [backend-adapters.stepfunctions.index :as stepfunctions]
            [backend-adapters.code-pipeline.index :as code-pipeline]
            [shared.protocols.loggable :as log]))

(def constructors {:db            #(dynamodb/create %)
                   :state-machine #(stepfunctions/create %)
                   :code-pipeline #(code-pipeline/create %)
                   :http          #(http/create %)
                   :embedly       #(embedly/create %)
                   :mercury       #(mercury/create %)
                   :auth          #(auth0/create %)
                   :iam           #(iam/create %)
                   :index         #(es/create %)
                   :github        #(github/create %)
                   :bucket        #(s3/create %)
                   :stream        #(kinesis/create %)})

(defn check [[key val]] (if-not val key (when (map? val) (keep check val))))

(defn create [adapters cb]
  (reduce (fn [acc [adapter-name config]]
            (let [errors (flatten (keep check config))]
              (if-not (empty? errors)
                (cb (clj->js (map #(str "envvar for " (name %) " not set") errors)) nil)
                (assoc acc adapter-name ((adapter-name constructors) config)))))
          {} adapters))
