(ns backend-shared.service.respond
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]
            [cljs.spec.alpha :as spec]
            [backend-adapters.embedly.index :as embedly]
            [shared.protocols.convertible :as cv]
            [shared.models.payload.index :as payload]))

(defmulti respond (fn [_ [_ res]] (sp/resolve (payload/create res))))

(defmethod respond :error [{:keys [callback event] :as service} [_ error :as response]]
  (let [error (merge error {:service-name  (:service-name service)
                            :stage         (:stage service)
                            :raw-event     event
                            :event         (:body event)})]
    (callback (.stringify js/JSON (clj->js error)))))

(defmethod respond :default [{:keys [callback is_endpoint?]} [_ payload :as response]]
  (callback nil (clj->js (if is_endpoint? (cv/to-api response) payload))))
