(ns backend-shared.models.payload.to-resource.embedly
  (:require [clojure.string :as str]
            [shared.models.resource.index :as rs]))


(defn valid-tag? [tag]
  (when-not (re-find #"[\.\.\.]|[(.*)]" tag)
    true))

(defn create-tag [{:keys [name] :as raw-tag}]
  (->> (str/split name " ")
       (map str/lower-case)
       (filter valid-tag?)
       (into #{})
       (take 3)
       (str/join "-")))

(defn to-resource [{:keys [original_url url type title description content
                           entities language keywords]}]
  (when-not (= "error" type)
    (let [record {:resource-url  url
                  :bookmark-url  (when (not= original_url url) original_url)
                  :title         title
                  :resource-type "html"
                  :content       content
                  :language      language
                  :description   description
                  :entities      (->> entities (map :name))
                  :tags          (into #{} (map create-tag keywords))}]
      (rs/create (into {} (remove (comp nil? second) record))))))
