(ns backend-shared.service.perform
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]
            [clojure.nodejs :as node]
            [shared.protocols.convertible :as cv]
            [cljs.spec.alpha :as spec]))

(def Zip (node/require "node-zip"))

(def zip-key :data)

(defmulti perform (fn [service action]
                    (sp/resolve action)))

(defmethod perform [:compress :resource] [_ [_ payload]]
  (-> (new Zip)
      (.file (name zip-key) (.stringify js/JSON (clj->js payload)))
      (.generate (clj->js {:base64 true :compression :DEFLATE}))))

(defmethod perform [:compress :raw-resource] [_ [_ payload]]
  (-> (new Zip)
      (.file (name zip-key) (.stringify js/JSON (clj->js payload)))
      (.generate (clj->js {:base64 true :compression :DEFLATE}))))

(defmethod perform [:deflate :compressed-data] [_ [_ payload]]
  (-> (new Zip (:compressed-data payload) (clj->js {:base64 true :checkCRC32 true}))
      cv/to-clj
      (get-in [:files zip-key :_data])
      cv/to-clj))

