(ns backend-shared.models.payload.to-user-data)

(defn extract-auth-id [{:keys [provider user_id]}]
  (str provider "|" user_id))

(defn to-profile [{:keys [user-name auth-profile]}]
  (-> auth-profile
      (dissoc :identities :picture)
      (assoc :user-name user-name
             :revision 1)))

(defn to-identity [auth-identity user-name]
  {:auth-id (extract-auth-id auth-identity)
   :user-name user-name})

(defn to-portrait [{:keys [user-name auth-profile]}]
  {:portrait-url (str (:picture auth-profile) "&s=300")
   :user-name user-name})

(defn to-identities [{:keys [auth-profile user-name]}]
  (map #(to-identity %1 user-name) (:identities auth-profile)))

(defn to-user-data [payload]
  {:profile (to-profile payload)
   :portrait (to-portrait payload)
   :identities (to-identities payload)})
