(ns backend-shared.models.payload.index
  (:require [backend-shared.models.payload.to-resource :refer [to-resource]]
            [backend-shared.models.payload.to-bookmarks :refer [to-bookmarks]]
            [shared.models.course.index :as course]
            [backend-shared.models.payload.to-course-update :refer [to-course-update]]
            [backend-shared.models.payload.to-repo-data :refer [to-repo-data]]
            [backend-shared.models.payload.to-user-data :refer [to-user-data]]
            [shared.models.payload.to-model :refer [to-model]]
            [shared.protocols.loggable :as log]))

(defmethod to-model :course [course]
  (to-bookmarks course))

(defmethod to-model :imported-course [raw-course]
  (course/initialize raw-course))

(defmethod to-model :repo [repo]
  (to-repo-data repo))

(defmethod to-model :mercury-resource [raw-resource]
  (to-resource raw-resource))

(defmethod to-model :embedly-resource [raw-resource]
  (to-resource raw-resource))

(defmethod to-model :augmented-bookmark [bookmark-data]
  (to-course-update bookmark-data))

(defmethod to-model :raw-user [raw-user]
  (to-user-data raw-user))
