(ns backend-shared.models.payload.to-resource
  (:require [shared.models.course.index :as co]
            [shared.models.profile.index :as profile]
            [shared.models.resource.index :as rs]
            [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]
            [clojure.string :as str]))

(defn valid-tag? [tag]
  (when-not (re-find #"[\.\.\.]|[(.*)]" tag)
    true))

(defn create-tag [{:keys [name] :as raw-tag}]
  (->> (str/split name " ")
       (map str/lower-case)
       (filter valid-tag?)
       (into #{})
       (take 3)
       (str/join "-")))

(defmulti to-resource #(sp/resolve %1))

(defmethod to-resource :mercury-resource [{:keys [url title excerpt content]}]
  (let [record {:resource-url  url
                :title         title
                :resource-type "html"
                :content       content
                :description   excerpt
                :tags          #{}}]
    (rs/create (into {} (remove (comp nil? second) record)))))

(defmethod to-resource :embedly-resource [{:keys [original_url url type title description content
                                               entities language keywords]}]
    (when-not (= "error" type)
      (let [record {:resource-url  url
                    :bookmark-url  (when (not= original_url url) original_url)
                    :title         title
                    :resource-type type
                    :content       content
                    :language      language
                    :description   description
                    :entities      (->> entities (map :name))
                    :tags          (into #{} (map create-tag keywords))}]
        (rs/create (into {} (remove (comp nil? second) record))))))
