(ns backend-shared.service.respond
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]
            [cljs.spec :as spec]
            [backend-adapters.embedly.index :as embedly]))

(defmulti respond (fn [_ [response-type]] response-type))

(defmethod respond :success [{:keys [callback]} [response-type payload]]
  (callback nil "accepted: resource is being created"))

(defmethod respond :reply [{:keys [callback]} [response-type payload]]
  (callback nil (.stringify js/JSON (clj->js payload))))

(defmethod respond :default [{:keys [callback]} [response-type payload]]
  (callback (str "[" (name response-type) "] " (name payload))))
