(ns backend-shared.service.respond
  (:require [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]))

(defmulti respond (fn [_ response] (sp/resolve response)))

(defmethod respond :api [{:keys [callback]} {:keys [statusCode body] :as response}]
  (if (>= statusCode 500)
    (callback (.stringify js/JSON (clj->js body)))
    (callback nil (clj->js response))))
