(ns hx-frame-sockets.utils
  (:require
   [clojure.string]
   [cljs.spec.alpha :as s]

   [hx-frame-sockets.db :as db]))

(defn ns-kw->ns-str
  [kw]
  (clojure.string/join "/" ((juxt namespace name) kw)))

(defn clj->JSON
  [obj]
  (-> obj
      (clj->js)
      (js/JSON.stringify)))

(defn JSON->clj
  [json]
  (-> json
      (js/JSON.parse)
      (js->clj :keywordize-keys true)))

(defn JSON->message
  [json]
  (-> json
      (JSON->clj)
      (update :action keyword)))

(defn event->message
  [event]
  (-> event
      .-data
      (JSON->message)))

(defn validate-message!
  [message error-message]
  (when (and (true? js/goog.DEBUG)
             (false? (s/valid? ::db/ws-message message)))
    (throw (js/Error.
            {:error error-message
             :message message
             :spec (s/explain-data ::db/ws-message message)}))))
