(ns hx-frame-sockets.subscriptions
  (:require [hx-frame.core :as hx-frame]))

(defn is-dispatching [db [_ request-id]]
  (-> db
      (get-in [:hx-frame-sockets :messages request-id])
      (some?)))

(defn is-dispatching-event [db [_ event-name]]
  (-> db
      (get-in [:hx-frame-sockets :messages])
      (vals)
      (set)
      (contains? event-name)))

(defn register-subscriptions
  []
  (hx-frame/register-subscription :hx-frame-sockets/is-dispatching-message
                                  is-dispatching)
  (hx-frame/register-subscription :hx-frame-sockets/is-dispatching-event
                                  is-dispatching-event))
