(ns hx-frame-sockets.core
  (:require
   [hx-frame-sockets.events :as hxs-events]
   [hx-frame-sockets.subscriptions :as hxs-subscriptions]))

(defn register-events
  "Registers hx-frame-request events and request handler"
  []
  (hxs-events/register-events))

(defn register-subscriptions
  "Registers hx-frame-request subscriptions"
  []
  (hxs-subscriptions/register-subscriptions))

(defn register-all
  "Registers both hx-frame-request events & subscriptions"
  []
  (register-events)
  (register-subscriptions))
