// Compiled by ClojureScript 1.10.520 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20821__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20818 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__20819 = cljs.core.seq.call(null,vec__20818);
var first__20820 = cljs.core.first.call(null,seq__20819);
var seq__20819__$1 = cljs.core.next.call(null,seq__20819);
var tag = first__20820;
var body = seq__20819__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args))], null),cljs.core.rest.call(null,body));
} else {
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first.call(null,args)], null),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20821 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20822__i = 0, G__20822__a = new Array(arguments.length -  0);
while (G__20822__i < G__20822__a.length) {G__20822__a[G__20822__i] = arguments[G__20822__i + 0]; ++G__20822__i;}
  args = new cljs.core.IndexedSeq(G__20822__a,0,null);
} 
return G__20821__delegate.call(this,args);};
G__20821.cljs$lang$maxFixedArity = 0;
G__20821.cljs$lang$applyTo = (function (arglist__20823){
var args = cljs.core.seq(arglist__20823);
return G__20821__delegate(args);
});
G__20821.cljs$core$IFn$_invoke$arity$variadic = G__20821__delegate;
return G__20821;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4523__auto__ = (function sablono$core$update_arglists_$_iter__20824(s__20825){
return (new cljs.core.LazySeq(null,(function (){
var s__20825__$1 = s__20825;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__20825__$1);
if(temp__5457__auto__){
var s__20825__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20825__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__20825__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__20827 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__20826 = (0);
while(true){
if((i__20826 < size__4522__auto__)){
var args = cljs.core._nth.call(null,c__4521__auto__,i__20826);
cljs.core.chunk_append.call(null,b__20827,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20828 = (i__20826 + (1));
i__20826 = G__20828;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20827),sablono$core$update_arglists_$_iter__20824.call(null,cljs.core.chunk_rest.call(null,s__20825__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20827),null);
}
} else {
var args = cljs.core.first.call(null,s__20825__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20824.call(null,cljs.core.rest.call(null,s__20825__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4736__auto__ = [];
var len__4730__auto___20834 = arguments.length;
var i__4731__auto___20835 = (0);
while(true){
if((i__4731__auto___20835 < len__4730__auto___20834)){
args__4736__auto__.push((arguments[i__4731__auto___20835]));

var G__20836 = (i__4731__auto___20835 + (1));
i__4731__auto___20835 = G__20836;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4523__auto__ = (function sablono$core$iter__20830(s__20831){
return (new cljs.core.LazySeq(null,(function (){
var s__20831__$1 = s__20831;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__20831__$1);
if(temp__5457__auto__){
var s__20831__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20831__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__20831__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__20833 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__20832 = (0);
while(true){
if((i__20832 < size__4522__auto__)){
var style = cljs.core._nth.call(null,c__4521__auto__,i__20832);
cljs.core.chunk_append.call(null,b__20833,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20837 = (i__20832 + (1));
i__20832 = G__20837;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20833),sablono$core$iter__20830.call(null,cljs.core.chunk_rest.call(null,s__20831__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20833),null);
}
} else {
var style = cljs.core.first.call(null,s__20831__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20830.call(null,cljs.core.rest.call(null,s__20831__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
sablono.core.include_css.cljs$lang$applyTo = (function (seq20829){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20829));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20838 = (function sablono$core$link_to20838(var_args){
var args__4736__auto__ = [];
var len__4730__auto___20841 = arguments.length;
var i__4731__auto___20842 = (0);
while(true){
if((i__4731__auto___20842 < len__4730__auto___20841)){
args__4736__auto__.push((arguments[i__4731__auto___20842]));

var G__20843 = (i__4731__auto___20842 + (1));
i__4731__auto___20842 = G__20843;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to20838.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

sablono.core.link_to20838.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20838.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.link_to20838.cljs$lang$applyTo = (function (seq20839){
var G__20840 = cljs.core.first.call(null,seq20839);
var seq20839__$1 = cljs.core.next.call(null,seq20839);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20840,seq20839__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20838);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20844 = (function sablono$core$mail_to20844(var_args){
var args__4736__auto__ = [];
var len__4730__auto___20851 = arguments.length;
var i__4731__auto___20852 = (0);
while(true){
if((i__4731__auto___20852 < len__4730__auto___20851)){
args__4736__auto__.push((arguments[i__4731__auto___20852]));

var G__20853 = (i__4731__auto___20852 + (1));
i__4731__auto___20852 = G__20853;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to20844.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

sablono.core.mail_to20844.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20847){
var vec__20848 = p__20847;
var content = cljs.core.nth.call(null,vec__20848,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__4131__auto__ = content;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20844.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.mail_to20844.cljs$lang$applyTo = (function (seq20845){
var G__20846 = cljs.core.first.call(null,seq20845);
var seq20845__$1 = cljs.core.next.call(null,seq20845);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20846,seq20845__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20844);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20854 = (function sablono$core$unordered_list20854(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4523__auto__ = (function sablono$core$unordered_list20854_$_iter__20855(s__20856){
return (new cljs.core.LazySeq(null,(function (){
var s__20856__$1 = s__20856;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__20856__$1);
if(temp__5457__auto__){
var s__20856__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20856__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__20856__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__20858 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__20857 = (0);
while(true){
if((i__20857 < size__4522__auto__)){
var x = cljs.core._nth.call(null,c__4521__auto__,i__20857);
cljs.core.chunk_append.call(null,b__20858,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20859 = (i__20857 + (1));
i__20857 = G__20859;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20858),sablono$core$unordered_list20854_$_iter__20855.call(null,cljs.core.chunk_rest.call(null,s__20856__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20858),null);
}
} else {
var x = cljs.core.first.call(null,s__20856__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20854_$_iter__20855.call(null,cljs.core.rest.call(null,s__20856__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20854);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20860 = (function sablono$core$ordered_list20860(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4523__auto__ = (function sablono$core$ordered_list20860_$_iter__20861(s__20862){
return (new cljs.core.LazySeq(null,(function (){
var s__20862__$1 = s__20862;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__20862__$1);
if(temp__5457__auto__){
var s__20862__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20862__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__20862__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__20864 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__20863 = (0);
while(true){
if((i__20863 < size__4522__auto__)){
var x = cljs.core._nth.call(null,c__4521__auto__,i__20863);
cljs.core.chunk_append.call(null,b__20864,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20865 = (i__20863 + (1));
i__20863 = G__20865;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20864),sablono$core$ordered_list20860_$_iter__20861.call(null,cljs.core.chunk_rest.call(null,s__20862__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20864),null);
}
} else {
var x = cljs.core.first.call(null,s__20862__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20860_$_iter__20861.call(null,cljs.core.rest.call(null,s__20862__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20860);
/**
 * Create an image element.
 */
sablono.core.image20866 = (function sablono$core$image20866(var_args){
var G__20868 = arguments.length;
switch (G__20868) {
case 1:
return sablono.core.image20866.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20866.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.image20866.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20866.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20866.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20866);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20870_SHARP_,p2__20871_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20870_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__20871_SHARP_),"]"].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20872_SHARP_,p2__20873_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20872_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__20873_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__20875 = arguments.length;
switch (G__20875) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4131__auto__ = value;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Creates a color input field.
 */
sablono.core.color_field20877 = (function sablono$core$color_field20877(var_args){
var G__20879 = arguments.length;
switch (G__20879) {
case 1:
return sablono.core.color_field20877.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20877.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.color_field20877.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__20808__auto__);
});

sablono.core.color_field20877.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.color_field20877.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20877);

/**
 * Creates a date input field.
 */
sablono.core.date_field20880 = (function sablono$core$date_field20880(var_args){
var G__20882 = arguments.length;
switch (G__20882) {
case 1:
return sablono.core.date_field20880.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20880.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.date_field20880.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__20808__auto__);
});

sablono.core.date_field20880.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.date_field20880.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20880);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20883 = (function sablono$core$datetime_field20883(var_args){
var G__20885 = arguments.length;
switch (G__20885) {
case 1:
return sablono.core.datetime_field20883.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20883.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_field20883.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__20808__auto__);
});

sablono.core.datetime_field20883.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.datetime_field20883.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20883);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20886 = (function sablono$core$datetime_local_field20886(var_args){
var G__20888 = arguments.length;
switch (G__20888) {
case 1:
return sablono.core.datetime_local_field20886.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20886.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_local_field20886.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__20808__auto__);
});

sablono.core.datetime_local_field20886.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.datetime_local_field20886.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20886);

/**
 * Creates a email input field.
 */
sablono.core.email_field20889 = (function sablono$core$email_field20889(var_args){
var G__20891 = arguments.length;
switch (G__20891) {
case 1:
return sablono.core.email_field20889.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20889.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.email_field20889.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__20808__auto__);
});

sablono.core.email_field20889.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.email_field20889.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20889);

/**
 * Creates a file input field.
 */
sablono.core.file_field20892 = (function sablono$core$file_field20892(var_args){
var G__20894 = arguments.length;
switch (G__20894) {
case 1:
return sablono.core.file_field20892.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20892.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.file_field20892.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__20808__auto__);
});

sablono.core.file_field20892.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.file_field20892.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20892);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20895 = (function sablono$core$hidden_field20895(var_args){
var G__20897 = arguments.length;
switch (G__20897) {
case 1:
return sablono.core.hidden_field20895.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20895.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.hidden_field20895.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__20808__auto__);
});

sablono.core.hidden_field20895.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.hidden_field20895.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20895);

/**
 * Creates a month input field.
 */
sablono.core.month_field20898 = (function sablono$core$month_field20898(var_args){
var G__20900 = arguments.length;
switch (G__20900) {
case 1:
return sablono.core.month_field20898.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20898.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.month_field20898.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__20808__auto__);
});

sablono.core.month_field20898.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.month_field20898.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20898);

/**
 * Creates a number input field.
 */
sablono.core.number_field20901 = (function sablono$core$number_field20901(var_args){
var G__20903 = arguments.length;
switch (G__20903) {
case 1:
return sablono.core.number_field20901.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20901.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.number_field20901.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__20808__auto__);
});

sablono.core.number_field20901.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.number_field20901.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20901);

/**
 * Creates a password input field.
 */
sablono.core.password_field20904 = (function sablono$core$password_field20904(var_args){
var G__20906 = arguments.length;
switch (G__20906) {
case 1:
return sablono.core.password_field20904.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20904.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.password_field20904.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__20808__auto__);
});

sablono.core.password_field20904.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.password_field20904.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20904);

/**
 * Creates a range input field.
 */
sablono.core.range_field20907 = (function sablono$core$range_field20907(var_args){
var G__20909 = arguments.length;
switch (G__20909) {
case 1:
return sablono.core.range_field20907.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20907.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.range_field20907.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__20808__auto__);
});

sablono.core.range_field20907.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.range_field20907.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20907);

/**
 * Creates a search input field.
 */
sablono.core.search_field20910 = (function sablono$core$search_field20910(var_args){
var G__20912 = arguments.length;
switch (G__20912) {
case 1:
return sablono.core.search_field20910.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20910.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.search_field20910.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__20808__auto__);
});

sablono.core.search_field20910.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.search_field20910.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20910);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20913 = (function sablono$core$tel_field20913(var_args){
var G__20915 = arguments.length;
switch (G__20915) {
case 1:
return sablono.core.tel_field20913.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20913.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.tel_field20913.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__20808__auto__);
});

sablono.core.tel_field20913.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.tel_field20913.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20913);

/**
 * Creates a text input field.
 */
sablono.core.text_field20916 = (function sablono$core$text_field20916(var_args){
var G__20918 = arguments.length;
switch (G__20918) {
case 1:
return sablono.core.text_field20916.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20916.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_field20916.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__20808__auto__);
});

sablono.core.text_field20916.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.text_field20916.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20916);

/**
 * Creates a time input field.
 */
sablono.core.time_field20919 = (function sablono$core$time_field20919(var_args){
var G__20921 = arguments.length;
switch (G__20921) {
case 1:
return sablono.core.time_field20919.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20919.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.time_field20919.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__20808__auto__);
});

sablono.core.time_field20919.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.time_field20919.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20919);

/**
 * Creates a url input field.
 */
sablono.core.url_field20922 = (function sablono$core$url_field20922(var_args){
var G__20924 = arguments.length;
switch (G__20924) {
case 1:
return sablono.core.url_field20922.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20922.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.url_field20922.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__20808__auto__);
});

sablono.core.url_field20922.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.url_field20922.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20922);

/**
 * Creates a week input field.
 */
sablono.core.week_field20925 = (function sablono$core$week_field20925(var_args){
var G__20927 = arguments.length;
switch (G__20927) {
case 1:
return sablono.core.week_field20925.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20925.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.week_field20925.cljs$core$IFn$_invoke$arity$1 = (function (name__20808__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__20808__auto__);
});

sablono.core.week_field20925.cljs$core$IFn$_invoke$arity$2 = (function (name__20808__auto__,value__20809__auto__){
return sablono.core.input_field_STAR_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__20808__auto__,value__20809__auto__);
});

sablono.core.week_field20925.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20925);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20945 = (function sablono$core$check_box20945(var_args){
var G__20947 = arguments.length;
switch (G__20947) {
case 1:
return sablono.core.check_box20945.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20945.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20945.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.check_box20945.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
});

sablono.core.check_box20945.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20945.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20945.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20945);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20949 = (function sablono$core$radio_button20949(var_args){
var G__20951 = arguments.length;
switch (G__20951) {
case 1:
return sablono.core.radio_button20949.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20949.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20949.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.radio_button20949.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,sablono.util.as_str.call(null,group))], null)], null);
});

sablono.core.radio_button20949.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,sablono.util.as_str.call(null,group)),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20949.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20949.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20949);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20953 = (function sablono$core$select_options20953(coll){
var iter__4523__auto__ = (function sablono$core$select_options20953_$_iter__20954(s__20955){
return (new cljs.core.LazySeq(null,(function (){
var s__20955__$1 = s__20955;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__20955__$1);
if(temp__5457__auto__){
var s__20955__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20955__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__20955__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__20957 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__20956 = (0);
while(true){
if((i__20956 < size__4522__auto__)){
var x = cljs.core._nth.call(null,c__4521__auto__,i__20956);
cljs.core.chunk_append.call(null,b__20957,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20958 = x;
var text = cljs.core.nth.call(null,vec__20958,(0),null);
var val = cljs.core.nth.call(null,vec__20958,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20958,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options20953.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20964 = (i__20956 + (1));
i__20956 = G__20964;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20957),sablono$core$select_options20953_$_iter__20954.call(null,cljs.core.chunk_rest.call(null,s__20955__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20957),null);
}
} else {
var x = cljs.core.first.call(null,s__20955__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20961 = x;
var text = cljs.core.nth.call(null,vec__20961,(0),null);
var val = cljs.core.nth.call(null,vec__20961,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20961,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options20953.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20953_$_iter__20954.call(null,cljs.core.rest.call(null,s__20955__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20953);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20965 = (function sablono$core$drop_down20965(var_args){
var G__20967 = arguments.length;
switch (G__20967) {
case 2:
return sablono.core.drop_down20965.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20965.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.drop_down20965.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20965.call(null,name,options,null);
});

sablono.core.drop_down20965.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20965.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20965);
/**
 * Creates a text area element.
 */
sablono.core.text_area20969 = (function sablono$core$text_area20969(var_args){
var G__20971 = arguments.length;
switch (G__20971) {
case 1:
return sablono.core.text_area20969.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20969.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_area20969.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null)], null);
});

sablono.core.text_area20969.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4131__auto__ = value;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area20969.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20969);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20973 = (function sablono$core$label20973(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20973);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20974 = (function sablono$core$submit_button20974(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20974);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20975 = (function sablono$core$reset_button20975(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20975);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20976 = (function sablono$core$form_to20976(var_args){
var args__4736__auto__ = [];
var len__4730__auto___20983 = arguments.length;
var i__4731__auto___20984 = (0);
while(true){
if((i__4731__auto___20984 < len__4730__auto___20983)){
args__4736__auto__.push((arguments[i__4731__auto___20984]));

var G__20985 = (i__4731__auto___20984 + (1));
i__4731__auto___20984 = G__20985;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to20976.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

sablono.core.form_to20976.cljs$core$IFn$_invoke$arity$variadic = (function (p__20979,body){
var vec__20980 = p__20979;
var method = cljs.core.nth.call(null,vec__20980,(0),null);
var action = cljs.core.nth.call(null,vec__20980,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20976.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.form_to20976.cljs$lang$applyTo = (function (seq20977){
var G__20978 = cljs.core.first.call(null,seq20977);
var seq20977__$1 = cljs.core.next.call(null,seq20977);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20978,seq20977__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20976);

//# sourceMappingURL=core.js.map
