// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__17039 = arguments.length;
switch (G__17039) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17040 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17040 = (function (f,blockable,meta17041){
this.f = f;
this.blockable = blockable;
this.meta17041 = meta17041;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17040.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17042,meta17041__$1){
var self__ = this;
var _17042__$1 = this;
return (new cljs.core.async.t_cljs$core$async17040(self__.f,self__.blockable,meta17041__$1));
});

cljs.core.async.t_cljs$core$async17040.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17042){
var self__ = this;
var _17042__$1 = this;
return self__.meta17041;
});

cljs.core.async.t_cljs$core$async17040.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17040.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17040.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17040.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17040.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17041","meta17041",213861541,null)], null);
});

cljs.core.async.t_cljs$core$async17040.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17040.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17040";

cljs.core.async.t_cljs$core$async17040.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async17040");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17040.
 */
cljs.core.async.__GT_t_cljs$core$async17040 = (function cljs$core$async$__GT_t_cljs$core$async17040(f__$1,blockable__$1,meta17041){
return (new cljs.core.async.t_cljs$core$async17040(f__$1,blockable__$1,meta17041));
});

}

return (new cljs.core.async.t_cljs$core$async17040(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__17046 = arguments.length;
switch (G__17046) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__17049 = arguments.length;
switch (G__17049) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__17052 = arguments.length;
switch (G__17052) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17054 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17054);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17054,ret){
return (function (){
return fn1.call(null,val_17054);
});})(val_17054,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__17056 = arguments.length;
switch (G__17056) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___17058 = n;
var x_17059 = (0);
while(true){
if((x_17059 < n__4607__auto___17058)){
(a[x_17059] = (0));

var G__17060 = (x_17059 + (1));
x_17059 = G__17060;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17061 = (i + (1));
i = G__17061;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17062 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17062 = (function (flag,meta17063){
this.flag = flag;
this.meta17063 = meta17063;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17062.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17064,meta17063__$1){
var self__ = this;
var _17064__$1 = this;
return (new cljs.core.async.t_cljs$core$async17062(self__.flag,meta17063__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17062.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17064){
var self__ = this;
var _17064__$1 = this;
return self__.meta17063;
});})(flag))
;

cljs.core.async.t_cljs$core$async17062.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17062.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17062.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17062.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17062.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17063","meta17063",-636996691,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17062.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17062.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17062";

cljs.core.async.t_cljs$core$async17062.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async17062");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17062.
 */
cljs.core.async.__GT_t_cljs$core$async17062 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17062(flag__$1,meta17063){
return (new cljs.core.async.t_cljs$core$async17062(flag__$1,meta17063));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17062(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17065 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17065 = (function (flag,cb,meta17066){
this.flag = flag;
this.cb = cb;
this.meta17066 = meta17066;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17065.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17067,meta17066__$1){
var self__ = this;
var _17067__$1 = this;
return (new cljs.core.async.t_cljs$core$async17065(self__.flag,self__.cb,meta17066__$1));
});

cljs.core.async.t_cljs$core$async17065.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17067){
var self__ = this;
var _17067__$1 = this;
return self__.meta17066;
});

cljs.core.async.t_cljs$core$async17065.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17065.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17065.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17065.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17065.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17066","meta17066",893824580,null)], null);
});

cljs.core.async.t_cljs$core$async17065.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17065.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17065";

cljs.core.async.t_cljs$core$async17065.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async17065");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17065.
 */
cljs.core.async.__GT_t_cljs$core$async17065 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17065(flag__$1,cb__$1,meta17066){
return (new cljs.core.async.t_cljs$core$async17065(flag__$1,cb__$1,meta17066));
});

}

return (new cljs.core.async.t_cljs$core$async17065(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17068_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17068_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17069_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17069_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17070 = (i + (1));
i = G__17070;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___17076 = arguments.length;
var i__4731__auto___17077 = (0);
while(true){
if((i__4731__auto___17077 < len__4730__auto___17076)){
args__4736__auto__.push((arguments[i__4731__auto___17077]));

var G__17078 = (i__4731__auto___17077 + (1));
i__4731__auto___17077 = G__17078;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17073){
var map__17074 = p__17073;
var map__17074__$1 = (((((!((map__17074 == null))))?(((((map__17074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17074.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17074):map__17074);
var opts = map__17074__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17071){
var G__17072 = cljs.core.first.call(null,seq17071);
var seq17071__$1 = cljs.core.next.call(null,seq17071);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17072,seq17071__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__17080 = arguments.length;
switch (G__17080) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16979__auto___17126 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___17126){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___17126){
return (function (state_17104){
var state_val_17105 = (state_17104[(1)]);
if((state_val_17105 === (7))){
var inst_17100 = (state_17104[(2)]);
var state_17104__$1 = state_17104;
var statearr_17106_17127 = state_17104__$1;
(statearr_17106_17127[(2)] = inst_17100);

(statearr_17106_17127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (1))){
var state_17104__$1 = state_17104;
var statearr_17107_17128 = state_17104__$1;
(statearr_17107_17128[(2)] = null);

(statearr_17107_17128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (4))){
var inst_17083 = (state_17104[(7)]);
var inst_17083__$1 = (state_17104[(2)]);
var inst_17084 = (inst_17083__$1 == null);
var state_17104__$1 = (function (){var statearr_17108 = state_17104;
(statearr_17108[(7)] = inst_17083__$1);

return statearr_17108;
})();
if(cljs.core.truth_(inst_17084)){
var statearr_17109_17129 = state_17104__$1;
(statearr_17109_17129[(1)] = (5));

} else {
var statearr_17110_17130 = state_17104__$1;
(statearr_17110_17130[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (13))){
var state_17104__$1 = state_17104;
var statearr_17111_17131 = state_17104__$1;
(statearr_17111_17131[(2)] = null);

(statearr_17111_17131[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (6))){
var inst_17083 = (state_17104[(7)]);
var state_17104__$1 = state_17104;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17104__$1,(11),to,inst_17083);
} else {
if((state_val_17105 === (3))){
var inst_17102 = (state_17104[(2)]);
var state_17104__$1 = state_17104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17104__$1,inst_17102);
} else {
if((state_val_17105 === (12))){
var state_17104__$1 = state_17104;
var statearr_17112_17132 = state_17104__$1;
(statearr_17112_17132[(2)] = null);

(statearr_17112_17132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (2))){
var state_17104__$1 = state_17104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17104__$1,(4),from);
} else {
if((state_val_17105 === (11))){
var inst_17093 = (state_17104[(2)]);
var state_17104__$1 = state_17104;
if(cljs.core.truth_(inst_17093)){
var statearr_17113_17133 = state_17104__$1;
(statearr_17113_17133[(1)] = (12));

} else {
var statearr_17114_17134 = state_17104__$1;
(statearr_17114_17134[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (9))){
var state_17104__$1 = state_17104;
var statearr_17115_17135 = state_17104__$1;
(statearr_17115_17135[(2)] = null);

(statearr_17115_17135[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (5))){
var state_17104__$1 = state_17104;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17116_17136 = state_17104__$1;
(statearr_17116_17136[(1)] = (8));

} else {
var statearr_17117_17137 = state_17104__$1;
(statearr_17117_17137[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (14))){
var inst_17098 = (state_17104[(2)]);
var state_17104__$1 = state_17104;
var statearr_17118_17138 = state_17104__$1;
(statearr_17118_17138[(2)] = inst_17098);

(statearr_17118_17138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (10))){
var inst_17090 = (state_17104[(2)]);
var state_17104__$1 = state_17104;
var statearr_17119_17139 = state_17104__$1;
(statearr_17119_17139[(2)] = inst_17090);

(statearr_17119_17139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17105 === (8))){
var inst_17087 = cljs.core.async.close_BANG_.call(null,to);
var state_17104__$1 = state_17104;
var statearr_17120_17140 = state_17104__$1;
(statearr_17120_17140[(2)] = inst_17087);

(statearr_17120_17140[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___17126))
;
return ((function (switch__16884__auto__,c__16979__auto___17126){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_17121 = [null,null,null,null,null,null,null,null];
(statearr_17121[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_17121[(1)] = (1));

return statearr_17121;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_17104){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17122){if((e17122 instanceof Object)){
var ex__16888__auto__ = e17122;
var statearr_17123_17141 = state_17104;
(statearr_17123_17141[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17122;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17142 = state_17104;
state_17104 = G__17142;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_17104){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_17104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___17126))
})();
var state__16981__auto__ = (function (){var statearr_17124 = f__16980__auto__.call(null);
(statearr_17124[(6)] = c__16979__auto___17126);

return statearr_17124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___17126))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17143){
var vec__17144 = p__17143;
var v = cljs.core.nth.call(null,vec__17144,(0),null);
var p = cljs.core.nth.call(null,vec__17144,(1),null);
var job = vec__17144;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__16979__auto___17315 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___17315,res,vec__17144,v,p,job,jobs,results){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___17315,res,vec__17144,v,p,job,jobs,results){
return (function (state_17151){
var state_val_17152 = (state_17151[(1)]);
if((state_val_17152 === (1))){
var state_17151__$1 = state_17151;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17151__$1,(2),res,v);
} else {
if((state_val_17152 === (2))){
var inst_17148 = (state_17151[(2)]);
var inst_17149 = cljs.core.async.close_BANG_.call(null,res);
var state_17151__$1 = (function (){var statearr_17153 = state_17151;
(statearr_17153[(7)] = inst_17148);

return statearr_17153;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17151__$1,inst_17149);
} else {
return null;
}
}
});})(c__16979__auto___17315,res,vec__17144,v,p,job,jobs,results))
;
return ((function (switch__16884__auto__,c__16979__auto___17315,res,vec__17144,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0 = (function (){
var statearr_17154 = [null,null,null,null,null,null,null,null];
(statearr_17154[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__);

(statearr_17154[(1)] = (1));

return statearr_17154;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1 = (function (state_17151){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17155){if((e17155 instanceof Object)){
var ex__16888__auto__ = e17155;
var statearr_17156_17316 = state_17151;
(statearr_17156_17316[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17151);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17155;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17317 = state_17151;
state_17151 = G__17317;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = function(state_17151){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1.call(this,state_17151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___17315,res,vec__17144,v,p,job,jobs,results))
})();
var state__16981__auto__ = (function (){var statearr_17157 = f__16980__auto__.call(null);
(statearr_17157[(6)] = c__16979__auto___17315);

return statearr_17157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___17315,res,vec__17144,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17158){
var vec__17159 = p__17158;
var v = cljs.core.nth.call(null,vec__17159,(0),null);
var p = cljs.core.nth.call(null,vec__17159,(1),null);
var job = vec__17159;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___17318 = n;
var __17319 = (0);
while(true){
if((__17319 < n__4607__auto___17318)){
var G__17162_17320 = type;
var G__17162_17321__$1 = (((G__17162_17320 instanceof cljs.core.Keyword))?G__17162_17320.fqn:null);
switch (G__17162_17321__$1) {
case "compute":
var c__16979__auto___17323 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17319,c__16979__auto___17323,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (__17319,c__16979__auto___17323,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async){
return (function (state_17175){
var state_val_17176 = (state_17175[(1)]);
if((state_val_17176 === (1))){
var state_17175__$1 = state_17175;
var statearr_17177_17324 = state_17175__$1;
(statearr_17177_17324[(2)] = null);

(statearr_17177_17324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17176 === (2))){
var state_17175__$1 = state_17175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17175__$1,(4),jobs);
} else {
if((state_val_17176 === (3))){
var inst_17173 = (state_17175[(2)]);
var state_17175__$1 = state_17175;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17175__$1,inst_17173);
} else {
if((state_val_17176 === (4))){
var inst_17165 = (state_17175[(2)]);
var inst_17166 = process.call(null,inst_17165);
var state_17175__$1 = state_17175;
if(cljs.core.truth_(inst_17166)){
var statearr_17178_17325 = state_17175__$1;
(statearr_17178_17325[(1)] = (5));

} else {
var statearr_17179_17326 = state_17175__$1;
(statearr_17179_17326[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17176 === (5))){
var state_17175__$1 = state_17175;
var statearr_17180_17327 = state_17175__$1;
(statearr_17180_17327[(2)] = null);

(statearr_17180_17327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17176 === (6))){
var state_17175__$1 = state_17175;
var statearr_17181_17328 = state_17175__$1;
(statearr_17181_17328[(2)] = null);

(statearr_17181_17328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17176 === (7))){
var inst_17171 = (state_17175[(2)]);
var state_17175__$1 = state_17175;
var statearr_17182_17329 = state_17175__$1;
(statearr_17182_17329[(2)] = inst_17171);

(statearr_17182_17329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17319,c__16979__auto___17323,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async))
;
return ((function (__17319,switch__16884__auto__,c__16979__auto___17323,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0 = (function (){
var statearr_17183 = [null,null,null,null,null,null,null];
(statearr_17183[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__);

(statearr_17183[(1)] = (1));

return statearr_17183;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1 = (function (state_17175){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17175);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17184){if((e17184 instanceof Object)){
var ex__16888__auto__ = e17184;
var statearr_17185_17330 = state_17175;
(statearr_17185_17330[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17175);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17184;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17331 = state_17175;
state_17175 = G__17331;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = function(state_17175){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1.call(this,state_17175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__;
})()
;})(__17319,switch__16884__auto__,c__16979__auto___17323,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async))
})();
var state__16981__auto__ = (function (){var statearr_17186 = f__16980__auto__.call(null);
(statearr_17186[(6)] = c__16979__auto___17323);

return statearr_17186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(__17319,c__16979__auto___17323,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async))
);


break;
case "async":
var c__16979__auto___17332 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17319,c__16979__auto___17332,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (__17319,c__16979__auto___17332,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async){
return (function (state_17199){
var state_val_17200 = (state_17199[(1)]);
if((state_val_17200 === (1))){
var state_17199__$1 = state_17199;
var statearr_17201_17333 = state_17199__$1;
(statearr_17201_17333[(2)] = null);

(statearr_17201_17333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (2))){
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17199__$1,(4),jobs);
} else {
if((state_val_17200 === (3))){
var inst_17197 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17199__$1,inst_17197);
} else {
if((state_val_17200 === (4))){
var inst_17189 = (state_17199[(2)]);
var inst_17190 = async.call(null,inst_17189);
var state_17199__$1 = state_17199;
if(cljs.core.truth_(inst_17190)){
var statearr_17202_17334 = state_17199__$1;
(statearr_17202_17334[(1)] = (5));

} else {
var statearr_17203_17335 = state_17199__$1;
(statearr_17203_17335[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (5))){
var state_17199__$1 = state_17199;
var statearr_17204_17336 = state_17199__$1;
(statearr_17204_17336[(2)] = null);

(statearr_17204_17336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (6))){
var state_17199__$1 = state_17199;
var statearr_17205_17337 = state_17199__$1;
(statearr_17205_17337[(2)] = null);

(statearr_17205_17337[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (7))){
var inst_17195 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
var statearr_17206_17338 = state_17199__$1;
(statearr_17206_17338[(2)] = inst_17195);

(statearr_17206_17338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17319,c__16979__auto___17332,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async))
;
return ((function (__17319,switch__16884__auto__,c__16979__auto___17332,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0 = (function (){
var statearr_17207 = [null,null,null,null,null,null,null];
(statearr_17207[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__);

(statearr_17207[(1)] = (1));

return statearr_17207;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1 = (function (state_17199){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17208){if((e17208 instanceof Object)){
var ex__16888__auto__ = e17208;
var statearr_17209_17339 = state_17199;
(statearr_17209_17339[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17199);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17208;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17340 = state_17199;
state_17199 = G__17340;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = function(state_17199){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1.call(this,state_17199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__;
})()
;})(__17319,switch__16884__auto__,c__16979__auto___17332,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async))
})();
var state__16981__auto__ = (function (){var statearr_17210 = f__16980__auto__.call(null);
(statearr_17210[(6)] = c__16979__auto___17332);

return statearr_17210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(__17319,c__16979__auto___17332,G__17162_17320,G__17162_17321__$1,n__4607__auto___17318,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17162_17321__$1)].join('')));

}

var G__17341 = (__17319 + (1));
__17319 = G__17341;
continue;
} else {
}
break;
}

var c__16979__auto___17342 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___17342,jobs,results,process,async){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___17342,jobs,results,process,async){
return (function (state_17232){
var state_val_17233 = (state_17232[(1)]);
if((state_val_17233 === (1))){
var state_17232__$1 = state_17232;
var statearr_17234_17343 = state_17232__$1;
(statearr_17234_17343[(2)] = null);

(statearr_17234_17343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17233 === (2))){
var state_17232__$1 = state_17232;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17232__$1,(4),from);
} else {
if((state_val_17233 === (3))){
var inst_17230 = (state_17232[(2)]);
var state_17232__$1 = state_17232;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17232__$1,inst_17230);
} else {
if((state_val_17233 === (4))){
var inst_17213 = (state_17232[(7)]);
var inst_17213__$1 = (state_17232[(2)]);
var inst_17214 = (inst_17213__$1 == null);
var state_17232__$1 = (function (){var statearr_17235 = state_17232;
(statearr_17235[(7)] = inst_17213__$1);

return statearr_17235;
})();
if(cljs.core.truth_(inst_17214)){
var statearr_17236_17344 = state_17232__$1;
(statearr_17236_17344[(1)] = (5));

} else {
var statearr_17237_17345 = state_17232__$1;
(statearr_17237_17345[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17233 === (5))){
var inst_17216 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17232__$1 = state_17232;
var statearr_17238_17346 = state_17232__$1;
(statearr_17238_17346[(2)] = inst_17216);

(statearr_17238_17346[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17233 === (6))){
var inst_17218 = (state_17232[(8)]);
var inst_17213 = (state_17232[(7)]);
var inst_17218__$1 = cljs.core.async.chan.call(null,(1));
var inst_17219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17220 = [inst_17213,inst_17218__$1];
var inst_17221 = (new cljs.core.PersistentVector(null,2,(5),inst_17219,inst_17220,null));
var state_17232__$1 = (function (){var statearr_17239 = state_17232;
(statearr_17239[(8)] = inst_17218__$1);

return statearr_17239;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17232__$1,(8),jobs,inst_17221);
} else {
if((state_val_17233 === (7))){
var inst_17228 = (state_17232[(2)]);
var state_17232__$1 = state_17232;
var statearr_17240_17347 = state_17232__$1;
(statearr_17240_17347[(2)] = inst_17228);

(statearr_17240_17347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17233 === (8))){
var inst_17218 = (state_17232[(8)]);
var inst_17223 = (state_17232[(2)]);
var state_17232__$1 = (function (){var statearr_17241 = state_17232;
(statearr_17241[(9)] = inst_17223);

return statearr_17241;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17232__$1,(9),results,inst_17218);
} else {
if((state_val_17233 === (9))){
var inst_17225 = (state_17232[(2)]);
var state_17232__$1 = (function (){var statearr_17242 = state_17232;
(statearr_17242[(10)] = inst_17225);

return statearr_17242;
})();
var statearr_17243_17348 = state_17232__$1;
(statearr_17243_17348[(2)] = null);

(statearr_17243_17348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___17342,jobs,results,process,async))
;
return ((function (switch__16884__auto__,c__16979__auto___17342,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0 = (function (){
var statearr_17244 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17244[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__);

(statearr_17244[(1)] = (1));

return statearr_17244;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1 = (function (state_17232){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17232);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17245){if((e17245 instanceof Object)){
var ex__16888__auto__ = e17245;
var statearr_17246_17349 = state_17232;
(statearr_17246_17349[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17232);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17245;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17350 = state_17232;
state_17232 = G__17350;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = function(state_17232){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1.call(this,state_17232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___17342,jobs,results,process,async))
})();
var state__16981__auto__ = (function (){var statearr_17247 = f__16980__auto__.call(null);
(statearr_17247[(6)] = c__16979__auto___17342);

return statearr_17247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___17342,jobs,results,process,async))
);


var c__16979__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto__,jobs,results,process,async){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto__,jobs,results,process,async){
return (function (state_17285){
var state_val_17286 = (state_17285[(1)]);
if((state_val_17286 === (7))){
var inst_17281 = (state_17285[(2)]);
var state_17285__$1 = state_17285;
var statearr_17287_17351 = state_17285__$1;
(statearr_17287_17351[(2)] = inst_17281);

(statearr_17287_17351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (20))){
var state_17285__$1 = state_17285;
var statearr_17288_17352 = state_17285__$1;
(statearr_17288_17352[(2)] = null);

(statearr_17288_17352[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (1))){
var state_17285__$1 = state_17285;
var statearr_17289_17353 = state_17285__$1;
(statearr_17289_17353[(2)] = null);

(statearr_17289_17353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (4))){
var inst_17250 = (state_17285[(7)]);
var inst_17250__$1 = (state_17285[(2)]);
var inst_17251 = (inst_17250__$1 == null);
var state_17285__$1 = (function (){var statearr_17290 = state_17285;
(statearr_17290[(7)] = inst_17250__$1);

return statearr_17290;
})();
if(cljs.core.truth_(inst_17251)){
var statearr_17291_17354 = state_17285__$1;
(statearr_17291_17354[(1)] = (5));

} else {
var statearr_17292_17355 = state_17285__$1;
(statearr_17292_17355[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (15))){
var inst_17263 = (state_17285[(8)]);
var state_17285__$1 = state_17285;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17285__$1,(18),to,inst_17263);
} else {
if((state_val_17286 === (21))){
var inst_17276 = (state_17285[(2)]);
var state_17285__$1 = state_17285;
var statearr_17293_17356 = state_17285__$1;
(statearr_17293_17356[(2)] = inst_17276);

(statearr_17293_17356[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (13))){
var inst_17278 = (state_17285[(2)]);
var state_17285__$1 = (function (){var statearr_17294 = state_17285;
(statearr_17294[(9)] = inst_17278);

return statearr_17294;
})();
var statearr_17295_17357 = state_17285__$1;
(statearr_17295_17357[(2)] = null);

(statearr_17295_17357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (6))){
var inst_17250 = (state_17285[(7)]);
var state_17285__$1 = state_17285;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17285__$1,(11),inst_17250);
} else {
if((state_val_17286 === (17))){
var inst_17271 = (state_17285[(2)]);
var state_17285__$1 = state_17285;
if(cljs.core.truth_(inst_17271)){
var statearr_17296_17358 = state_17285__$1;
(statearr_17296_17358[(1)] = (19));

} else {
var statearr_17297_17359 = state_17285__$1;
(statearr_17297_17359[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (3))){
var inst_17283 = (state_17285[(2)]);
var state_17285__$1 = state_17285;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17285__$1,inst_17283);
} else {
if((state_val_17286 === (12))){
var inst_17260 = (state_17285[(10)]);
var state_17285__$1 = state_17285;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17285__$1,(14),inst_17260);
} else {
if((state_val_17286 === (2))){
var state_17285__$1 = state_17285;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17285__$1,(4),results);
} else {
if((state_val_17286 === (19))){
var state_17285__$1 = state_17285;
var statearr_17298_17360 = state_17285__$1;
(statearr_17298_17360[(2)] = null);

(statearr_17298_17360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (11))){
var inst_17260 = (state_17285[(2)]);
var state_17285__$1 = (function (){var statearr_17299 = state_17285;
(statearr_17299[(10)] = inst_17260);

return statearr_17299;
})();
var statearr_17300_17361 = state_17285__$1;
(statearr_17300_17361[(2)] = null);

(statearr_17300_17361[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (9))){
var state_17285__$1 = state_17285;
var statearr_17301_17362 = state_17285__$1;
(statearr_17301_17362[(2)] = null);

(statearr_17301_17362[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (5))){
var state_17285__$1 = state_17285;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17302_17363 = state_17285__$1;
(statearr_17302_17363[(1)] = (8));

} else {
var statearr_17303_17364 = state_17285__$1;
(statearr_17303_17364[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (14))){
var inst_17263 = (state_17285[(8)]);
var inst_17265 = (state_17285[(11)]);
var inst_17263__$1 = (state_17285[(2)]);
var inst_17264 = (inst_17263__$1 == null);
var inst_17265__$1 = cljs.core.not.call(null,inst_17264);
var state_17285__$1 = (function (){var statearr_17304 = state_17285;
(statearr_17304[(8)] = inst_17263__$1);

(statearr_17304[(11)] = inst_17265__$1);

return statearr_17304;
})();
if(inst_17265__$1){
var statearr_17305_17365 = state_17285__$1;
(statearr_17305_17365[(1)] = (15));

} else {
var statearr_17306_17366 = state_17285__$1;
(statearr_17306_17366[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (16))){
var inst_17265 = (state_17285[(11)]);
var state_17285__$1 = state_17285;
var statearr_17307_17367 = state_17285__$1;
(statearr_17307_17367[(2)] = inst_17265);

(statearr_17307_17367[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (10))){
var inst_17257 = (state_17285[(2)]);
var state_17285__$1 = state_17285;
var statearr_17308_17368 = state_17285__$1;
(statearr_17308_17368[(2)] = inst_17257);

(statearr_17308_17368[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (18))){
var inst_17268 = (state_17285[(2)]);
var state_17285__$1 = state_17285;
var statearr_17309_17369 = state_17285__$1;
(statearr_17309_17369[(2)] = inst_17268);

(statearr_17309_17369[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17286 === (8))){
var inst_17254 = cljs.core.async.close_BANG_.call(null,to);
var state_17285__$1 = state_17285;
var statearr_17310_17370 = state_17285__$1;
(statearr_17310_17370[(2)] = inst_17254);

(statearr_17310_17370[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto__,jobs,results,process,async))
;
return ((function (switch__16884__auto__,c__16979__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0 = (function (){
var statearr_17311 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17311[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__);

(statearr_17311[(1)] = (1));

return statearr_17311;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1 = (function (state_17285){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17285);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17312){if((e17312 instanceof Object)){
var ex__16888__auto__ = e17312;
var statearr_17313_17371 = state_17285;
(statearr_17313_17371[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17285);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17312;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17372 = state_17285;
state_17285 = G__17372;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__ = function(state_17285){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1.call(this,state_17285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16885__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto__,jobs,results,process,async))
})();
var state__16981__auto__ = (function (){var statearr_17314 = f__16980__auto__.call(null);
(statearr_17314[(6)] = c__16979__auto__);

return statearr_17314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto__,jobs,results,process,async))
);

return c__16979__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17374 = arguments.length;
switch (G__17374) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17377 = arguments.length;
switch (G__17377) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17380 = arguments.length;
switch (G__17380) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__16979__auto___17429 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___17429,tc,fc){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___17429,tc,fc){
return (function (state_17406){
var state_val_17407 = (state_17406[(1)]);
if((state_val_17407 === (7))){
var inst_17402 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
var statearr_17408_17430 = state_17406__$1;
(statearr_17408_17430[(2)] = inst_17402);

(statearr_17408_17430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (1))){
var state_17406__$1 = state_17406;
var statearr_17409_17431 = state_17406__$1;
(statearr_17409_17431[(2)] = null);

(statearr_17409_17431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (4))){
var inst_17383 = (state_17406[(7)]);
var inst_17383__$1 = (state_17406[(2)]);
var inst_17384 = (inst_17383__$1 == null);
var state_17406__$1 = (function (){var statearr_17410 = state_17406;
(statearr_17410[(7)] = inst_17383__$1);

return statearr_17410;
})();
if(cljs.core.truth_(inst_17384)){
var statearr_17411_17432 = state_17406__$1;
(statearr_17411_17432[(1)] = (5));

} else {
var statearr_17412_17433 = state_17406__$1;
(statearr_17412_17433[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (13))){
var state_17406__$1 = state_17406;
var statearr_17413_17434 = state_17406__$1;
(statearr_17413_17434[(2)] = null);

(statearr_17413_17434[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (6))){
var inst_17383 = (state_17406[(7)]);
var inst_17389 = p.call(null,inst_17383);
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17389)){
var statearr_17414_17435 = state_17406__$1;
(statearr_17414_17435[(1)] = (9));

} else {
var statearr_17415_17436 = state_17406__$1;
(statearr_17415_17436[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (3))){
var inst_17404 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17406__$1,inst_17404);
} else {
if((state_val_17407 === (12))){
var state_17406__$1 = state_17406;
var statearr_17416_17437 = state_17406__$1;
(statearr_17416_17437[(2)] = null);

(statearr_17416_17437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (2))){
var state_17406__$1 = state_17406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17406__$1,(4),ch);
} else {
if((state_val_17407 === (11))){
var inst_17383 = (state_17406[(7)]);
var inst_17393 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17406__$1,(8),inst_17393,inst_17383);
} else {
if((state_val_17407 === (9))){
var state_17406__$1 = state_17406;
var statearr_17417_17438 = state_17406__$1;
(statearr_17417_17438[(2)] = tc);

(statearr_17417_17438[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (5))){
var inst_17386 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17387 = cljs.core.async.close_BANG_.call(null,fc);
var state_17406__$1 = (function (){var statearr_17418 = state_17406;
(statearr_17418[(8)] = inst_17386);

return statearr_17418;
})();
var statearr_17419_17439 = state_17406__$1;
(statearr_17419_17439[(2)] = inst_17387);

(statearr_17419_17439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (14))){
var inst_17400 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
var statearr_17420_17440 = state_17406__$1;
(statearr_17420_17440[(2)] = inst_17400);

(statearr_17420_17440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (10))){
var state_17406__$1 = state_17406;
var statearr_17421_17441 = state_17406__$1;
(statearr_17421_17441[(2)] = fc);

(statearr_17421_17441[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17407 === (8))){
var inst_17395 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17395)){
var statearr_17422_17442 = state_17406__$1;
(statearr_17422_17442[(1)] = (12));

} else {
var statearr_17423_17443 = state_17406__$1;
(statearr_17423_17443[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___17429,tc,fc))
;
return ((function (switch__16884__auto__,c__16979__auto___17429,tc,fc){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_17424 = [null,null,null,null,null,null,null,null,null];
(statearr_17424[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_17424[(1)] = (1));

return statearr_17424;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_17406){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17425){if((e17425 instanceof Object)){
var ex__16888__auto__ = e17425;
var statearr_17426_17444 = state_17406;
(statearr_17426_17444[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17406);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17425;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17445 = state_17406;
state_17406 = G__17445;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_17406){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_17406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___17429,tc,fc))
})();
var state__16981__auto__ = (function (){var statearr_17427 = f__16980__auto__.call(null);
(statearr_17427[(6)] = c__16979__auto___17429);

return statearr_17427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___17429,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16979__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto__){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto__){
return (function (state_17466){
var state_val_17467 = (state_17466[(1)]);
if((state_val_17467 === (7))){
var inst_17462 = (state_17466[(2)]);
var state_17466__$1 = state_17466;
var statearr_17468_17486 = state_17466__$1;
(statearr_17468_17486[(2)] = inst_17462);

(statearr_17468_17486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (1))){
var inst_17446 = init;
var state_17466__$1 = (function (){var statearr_17469 = state_17466;
(statearr_17469[(7)] = inst_17446);

return statearr_17469;
})();
var statearr_17470_17487 = state_17466__$1;
(statearr_17470_17487[(2)] = null);

(statearr_17470_17487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (4))){
var inst_17449 = (state_17466[(8)]);
var inst_17449__$1 = (state_17466[(2)]);
var inst_17450 = (inst_17449__$1 == null);
var state_17466__$1 = (function (){var statearr_17471 = state_17466;
(statearr_17471[(8)] = inst_17449__$1);

return statearr_17471;
})();
if(cljs.core.truth_(inst_17450)){
var statearr_17472_17488 = state_17466__$1;
(statearr_17472_17488[(1)] = (5));

} else {
var statearr_17473_17489 = state_17466__$1;
(statearr_17473_17489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (6))){
var inst_17453 = (state_17466[(9)]);
var inst_17446 = (state_17466[(7)]);
var inst_17449 = (state_17466[(8)]);
var inst_17453__$1 = f.call(null,inst_17446,inst_17449);
var inst_17454 = cljs.core.reduced_QMARK_.call(null,inst_17453__$1);
var state_17466__$1 = (function (){var statearr_17474 = state_17466;
(statearr_17474[(9)] = inst_17453__$1);

return statearr_17474;
})();
if(inst_17454){
var statearr_17475_17490 = state_17466__$1;
(statearr_17475_17490[(1)] = (8));

} else {
var statearr_17476_17491 = state_17466__$1;
(statearr_17476_17491[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (3))){
var inst_17464 = (state_17466[(2)]);
var state_17466__$1 = state_17466;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17466__$1,inst_17464);
} else {
if((state_val_17467 === (2))){
var state_17466__$1 = state_17466;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17466__$1,(4),ch);
} else {
if((state_val_17467 === (9))){
var inst_17453 = (state_17466[(9)]);
var inst_17446 = inst_17453;
var state_17466__$1 = (function (){var statearr_17477 = state_17466;
(statearr_17477[(7)] = inst_17446);

return statearr_17477;
})();
var statearr_17478_17492 = state_17466__$1;
(statearr_17478_17492[(2)] = null);

(statearr_17478_17492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (5))){
var inst_17446 = (state_17466[(7)]);
var state_17466__$1 = state_17466;
var statearr_17479_17493 = state_17466__$1;
(statearr_17479_17493[(2)] = inst_17446);

(statearr_17479_17493[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (10))){
var inst_17460 = (state_17466[(2)]);
var state_17466__$1 = state_17466;
var statearr_17480_17494 = state_17466__$1;
(statearr_17480_17494[(2)] = inst_17460);

(statearr_17480_17494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17467 === (8))){
var inst_17453 = (state_17466[(9)]);
var inst_17456 = cljs.core.deref.call(null,inst_17453);
var state_17466__$1 = state_17466;
var statearr_17481_17495 = state_17466__$1;
(statearr_17481_17495[(2)] = inst_17456);

(statearr_17481_17495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto__))
;
return ((function (switch__16884__auto__,c__16979__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16885__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16885__auto____0 = (function (){
var statearr_17482 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17482[(0)] = cljs$core$async$reduce_$_state_machine__16885__auto__);

(statearr_17482[(1)] = (1));

return statearr_17482;
});
var cljs$core$async$reduce_$_state_machine__16885__auto____1 = (function (state_17466){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17466);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17483){if((e17483 instanceof Object)){
var ex__16888__auto__ = e17483;
var statearr_17484_17496 = state_17466;
(statearr_17484_17496[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17466);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17483;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17497 = state_17466;
state_17466 = G__17497;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16885__auto__ = function(state_17466){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16885__auto____1.call(this,state_17466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16885__auto____0;
cljs$core$async$reduce_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16885__auto____1;
return cljs$core$async$reduce_$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto__))
})();
var state__16981__auto__ = (function (){var statearr_17485 = f__16980__auto__.call(null);
(statearr_17485[(6)] = c__16979__auto__);

return statearr_17485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto__))
);

return c__16979__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__16979__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto__,f__$1){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto__,f__$1){
return (function (state_17503){
var state_val_17504 = (state_17503[(1)]);
if((state_val_17504 === (1))){
var inst_17498 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_17503__$1 = state_17503;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17503__$1,(2),inst_17498);
} else {
if((state_val_17504 === (2))){
var inst_17500 = (state_17503[(2)]);
var inst_17501 = f__$1.call(null,inst_17500);
var state_17503__$1 = state_17503;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17503__$1,inst_17501);
} else {
return null;
}
}
});})(c__16979__auto__,f__$1))
;
return ((function (switch__16884__auto__,c__16979__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16885__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16885__auto____0 = (function (){
var statearr_17505 = [null,null,null,null,null,null,null];
(statearr_17505[(0)] = cljs$core$async$transduce_$_state_machine__16885__auto__);

(statearr_17505[(1)] = (1));

return statearr_17505;
});
var cljs$core$async$transduce_$_state_machine__16885__auto____1 = (function (state_17503){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17503);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17506){if((e17506 instanceof Object)){
var ex__16888__auto__ = e17506;
var statearr_17507_17509 = state_17503;
(statearr_17507_17509[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17503);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17506;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17510 = state_17503;
state_17503 = G__17510;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16885__auto__ = function(state_17503){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16885__auto____1.call(this,state_17503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16885__auto____0;
cljs$core$async$transduce_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16885__auto____1;
return cljs$core$async$transduce_$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto__,f__$1))
})();
var state__16981__auto__ = (function (){var statearr_17508 = f__16980__auto__.call(null);
(statearr_17508[(6)] = c__16979__auto__);

return statearr_17508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto__,f__$1))
);

return c__16979__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17512 = arguments.length;
switch (G__17512) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16979__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto__){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto__){
return (function (state_17537){
var state_val_17538 = (state_17537[(1)]);
if((state_val_17538 === (7))){
var inst_17519 = (state_17537[(2)]);
var state_17537__$1 = state_17537;
var statearr_17539_17560 = state_17537__$1;
(statearr_17539_17560[(2)] = inst_17519);

(statearr_17539_17560[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (1))){
var inst_17513 = cljs.core.seq.call(null,coll);
var inst_17514 = inst_17513;
var state_17537__$1 = (function (){var statearr_17540 = state_17537;
(statearr_17540[(7)] = inst_17514);

return statearr_17540;
})();
var statearr_17541_17561 = state_17537__$1;
(statearr_17541_17561[(2)] = null);

(statearr_17541_17561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (4))){
var inst_17514 = (state_17537[(7)]);
var inst_17517 = cljs.core.first.call(null,inst_17514);
var state_17537__$1 = state_17537;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17537__$1,(7),ch,inst_17517);
} else {
if((state_val_17538 === (13))){
var inst_17531 = (state_17537[(2)]);
var state_17537__$1 = state_17537;
var statearr_17542_17562 = state_17537__$1;
(statearr_17542_17562[(2)] = inst_17531);

(statearr_17542_17562[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (6))){
var inst_17522 = (state_17537[(2)]);
var state_17537__$1 = state_17537;
if(cljs.core.truth_(inst_17522)){
var statearr_17543_17563 = state_17537__$1;
(statearr_17543_17563[(1)] = (8));

} else {
var statearr_17544_17564 = state_17537__$1;
(statearr_17544_17564[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (3))){
var inst_17535 = (state_17537[(2)]);
var state_17537__$1 = state_17537;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17537__$1,inst_17535);
} else {
if((state_val_17538 === (12))){
var state_17537__$1 = state_17537;
var statearr_17545_17565 = state_17537__$1;
(statearr_17545_17565[(2)] = null);

(statearr_17545_17565[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (2))){
var inst_17514 = (state_17537[(7)]);
var state_17537__$1 = state_17537;
if(cljs.core.truth_(inst_17514)){
var statearr_17546_17566 = state_17537__$1;
(statearr_17546_17566[(1)] = (4));

} else {
var statearr_17547_17567 = state_17537__$1;
(statearr_17547_17567[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (11))){
var inst_17528 = cljs.core.async.close_BANG_.call(null,ch);
var state_17537__$1 = state_17537;
var statearr_17548_17568 = state_17537__$1;
(statearr_17548_17568[(2)] = inst_17528);

(statearr_17548_17568[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (9))){
var state_17537__$1 = state_17537;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17549_17569 = state_17537__$1;
(statearr_17549_17569[(1)] = (11));

} else {
var statearr_17550_17570 = state_17537__$1;
(statearr_17550_17570[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (5))){
var inst_17514 = (state_17537[(7)]);
var state_17537__$1 = state_17537;
var statearr_17551_17571 = state_17537__$1;
(statearr_17551_17571[(2)] = inst_17514);

(statearr_17551_17571[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (10))){
var inst_17533 = (state_17537[(2)]);
var state_17537__$1 = state_17537;
var statearr_17552_17572 = state_17537__$1;
(statearr_17552_17572[(2)] = inst_17533);

(statearr_17552_17572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17538 === (8))){
var inst_17514 = (state_17537[(7)]);
var inst_17524 = cljs.core.next.call(null,inst_17514);
var inst_17514__$1 = inst_17524;
var state_17537__$1 = (function (){var statearr_17553 = state_17537;
(statearr_17553[(7)] = inst_17514__$1);

return statearr_17553;
})();
var statearr_17554_17573 = state_17537__$1;
(statearr_17554_17573[(2)] = null);

(statearr_17554_17573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto__))
;
return ((function (switch__16884__auto__,c__16979__auto__){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_17555 = [null,null,null,null,null,null,null,null];
(statearr_17555[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_17555[(1)] = (1));

return statearr_17555;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_17537){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17537);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17556){if((e17556 instanceof Object)){
var ex__16888__auto__ = e17556;
var statearr_17557_17574 = state_17537;
(statearr_17557_17574[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17537);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17556;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17575 = state_17537;
state_17537 = G__17575;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_17537){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_17537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto__))
})();
var state__16981__auto__ = (function (){var statearr_17558 = f__16980__auto__.call(null);
(statearr_17558[(6)] = c__16979__auto__);

return statearr_17558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto__))
);

return c__16979__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17576 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17576 = (function (ch,cs,meta17577){
this.ch = ch;
this.cs = cs;
this.meta17577 = meta17577;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17578,meta17577__$1){
var self__ = this;
var _17578__$1 = this;
return (new cljs.core.async.t_cljs$core$async17576(self__.ch,self__.cs,meta17577__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17578){
var self__ = this;
var _17578__$1 = this;
return self__.meta17577;
});})(cs))
;

cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17576.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17576.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta17577","meta17577",-443471232,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17576.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17576.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17576";

cljs.core.async.t_cljs$core$async17576.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async17576");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17576.
 */
cljs.core.async.__GT_t_cljs$core$async17576 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17576(ch__$1,cs__$1,meta17577){
return (new cljs.core.async.t_cljs$core$async17576(ch__$1,cs__$1,meta17577));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17576(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16979__auto___17798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___17798,cs,m,dchan,dctr,done){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___17798,cs,m,dchan,dctr,done){
return (function (state_17713){
var state_val_17714 = (state_17713[(1)]);
if((state_val_17714 === (7))){
var inst_17709 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17715_17799 = state_17713__$1;
(statearr_17715_17799[(2)] = inst_17709);

(statearr_17715_17799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (20))){
var inst_17612 = (state_17713[(7)]);
var inst_17624 = cljs.core.first.call(null,inst_17612);
var inst_17625 = cljs.core.nth.call(null,inst_17624,(0),null);
var inst_17626 = cljs.core.nth.call(null,inst_17624,(1),null);
var state_17713__$1 = (function (){var statearr_17716 = state_17713;
(statearr_17716[(8)] = inst_17625);

return statearr_17716;
})();
if(cljs.core.truth_(inst_17626)){
var statearr_17717_17800 = state_17713__$1;
(statearr_17717_17800[(1)] = (22));

} else {
var statearr_17718_17801 = state_17713__$1;
(statearr_17718_17801[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (27))){
var inst_17661 = (state_17713[(9)]);
var inst_17656 = (state_17713[(10)]);
var inst_17581 = (state_17713[(11)]);
var inst_17654 = (state_17713[(12)]);
var inst_17661__$1 = cljs.core._nth.call(null,inst_17654,inst_17656);
var inst_17662 = cljs.core.async.put_BANG_.call(null,inst_17661__$1,inst_17581,done);
var state_17713__$1 = (function (){var statearr_17719 = state_17713;
(statearr_17719[(9)] = inst_17661__$1);

return statearr_17719;
})();
if(cljs.core.truth_(inst_17662)){
var statearr_17720_17802 = state_17713__$1;
(statearr_17720_17802[(1)] = (30));

} else {
var statearr_17721_17803 = state_17713__$1;
(statearr_17721_17803[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (1))){
var state_17713__$1 = state_17713;
var statearr_17722_17804 = state_17713__$1;
(statearr_17722_17804[(2)] = null);

(statearr_17722_17804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (24))){
var inst_17612 = (state_17713[(7)]);
var inst_17631 = (state_17713[(2)]);
var inst_17632 = cljs.core.next.call(null,inst_17612);
var inst_17590 = inst_17632;
var inst_17591 = null;
var inst_17592 = (0);
var inst_17593 = (0);
var state_17713__$1 = (function (){var statearr_17723 = state_17713;
(statearr_17723[(13)] = inst_17593);

(statearr_17723[(14)] = inst_17631);

(statearr_17723[(15)] = inst_17591);

(statearr_17723[(16)] = inst_17592);

(statearr_17723[(17)] = inst_17590);

return statearr_17723;
})();
var statearr_17724_17805 = state_17713__$1;
(statearr_17724_17805[(2)] = null);

(statearr_17724_17805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (39))){
var state_17713__$1 = state_17713;
var statearr_17728_17806 = state_17713__$1;
(statearr_17728_17806[(2)] = null);

(statearr_17728_17806[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (4))){
var inst_17581 = (state_17713[(11)]);
var inst_17581__$1 = (state_17713[(2)]);
var inst_17582 = (inst_17581__$1 == null);
var state_17713__$1 = (function (){var statearr_17729 = state_17713;
(statearr_17729[(11)] = inst_17581__$1);

return statearr_17729;
})();
if(cljs.core.truth_(inst_17582)){
var statearr_17730_17807 = state_17713__$1;
(statearr_17730_17807[(1)] = (5));

} else {
var statearr_17731_17808 = state_17713__$1;
(statearr_17731_17808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (15))){
var inst_17593 = (state_17713[(13)]);
var inst_17591 = (state_17713[(15)]);
var inst_17592 = (state_17713[(16)]);
var inst_17590 = (state_17713[(17)]);
var inst_17608 = (state_17713[(2)]);
var inst_17609 = (inst_17593 + (1));
var tmp17725 = inst_17591;
var tmp17726 = inst_17592;
var tmp17727 = inst_17590;
var inst_17590__$1 = tmp17727;
var inst_17591__$1 = tmp17725;
var inst_17592__$1 = tmp17726;
var inst_17593__$1 = inst_17609;
var state_17713__$1 = (function (){var statearr_17732 = state_17713;
(statearr_17732[(13)] = inst_17593__$1);

(statearr_17732[(15)] = inst_17591__$1);

(statearr_17732[(16)] = inst_17592__$1);

(statearr_17732[(17)] = inst_17590__$1);

(statearr_17732[(18)] = inst_17608);

return statearr_17732;
})();
var statearr_17733_17809 = state_17713__$1;
(statearr_17733_17809[(2)] = null);

(statearr_17733_17809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (21))){
var inst_17635 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17737_17810 = state_17713__$1;
(statearr_17737_17810[(2)] = inst_17635);

(statearr_17737_17810[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (31))){
var inst_17661 = (state_17713[(9)]);
var inst_17665 = done.call(null,null);
var inst_17666 = cljs.core.async.untap_STAR_.call(null,m,inst_17661);
var state_17713__$1 = (function (){var statearr_17738 = state_17713;
(statearr_17738[(19)] = inst_17665);

return statearr_17738;
})();
var statearr_17739_17811 = state_17713__$1;
(statearr_17739_17811[(2)] = inst_17666);

(statearr_17739_17811[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (32))){
var inst_17653 = (state_17713[(20)]);
var inst_17656 = (state_17713[(10)]);
var inst_17654 = (state_17713[(12)]);
var inst_17655 = (state_17713[(21)]);
var inst_17668 = (state_17713[(2)]);
var inst_17669 = (inst_17656 + (1));
var tmp17734 = inst_17653;
var tmp17735 = inst_17654;
var tmp17736 = inst_17655;
var inst_17653__$1 = tmp17734;
var inst_17654__$1 = tmp17735;
var inst_17655__$1 = tmp17736;
var inst_17656__$1 = inst_17669;
var state_17713__$1 = (function (){var statearr_17740 = state_17713;
(statearr_17740[(20)] = inst_17653__$1);

(statearr_17740[(10)] = inst_17656__$1);

(statearr_17740[(12)] = inst_17654__$1);

(statearr_17740[(21)] = inst_17655__$1);

(statearr_17740[(22)] = inst_17668);

return statearr_17740;
})();
var statearr_17741_17812 = state_17713__$1;
(statearr_17741_17812[(2)] = null);

(statearr_17741_17812[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (40))){
var inst_17681 = (state_17713[(23)]);
var inst_17685 = done.call(null,null);
var inst_17686 = cljs.core.async.untap_STAR_.call(null,m,inst_17681);
var state_17713__$1 = (function (){var statearr_17742 = state_17713;
(statearr_17742[(24)] = inst_17685);

return statearr_17742;
})();
var statearr_17743_17813 = state_17713__$1;
(statearr_17743_17813[(2)] = inst_17686);

(statearr_17743_17813[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (33))){
var inst_17672 = (state_17713[(25)]);
var inst_17674 = cljs.core.chunked_seq_QMARK_.call(null,inst_17672);
var state_17713__$1 = state_17713;
if(inst_17674){
var statearr_17744_17814 = state_17713__$1;
(statearr_17744_17814[(1)] = (36));

} else {
var statearr_17745_17815 = state_17713__$1;
(statearr_17745_17815[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (13))){
var inst_17602 = (state_17713[(26)]);
var inst_17605 = cljs.core.async.close_BANG_.call(null,inst_17602);
var state_17713__$1 = state_17713;
var statearr_17746_17816 = state_17713__$1;
(statearr_17746_17816[(2)] = inst_17605);

(statearr_17746_17816[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (22))){
var inst_17625 = (state_17713[(8)]);
var inst_17628 = cljs.core.async.close_BANG_.call(null,inst_17625);
var state_17713__$1 = state_17713;
var statearr_17747_17817 = state_17713__$1;
(statearr_17747_17817[(2)] = inst_17628);

(statearr_17747_17817[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (36))){
var inst_17672 = (state_17713[(25)]);
var inst_17676 = cljs.core.chunk_first.call(null,inst_17672);
var inst_17677 = cljs.core.chunk_rest.call(null,inst_17672);
var inst_17678 = cljs.core.count.call(null,inst_17676);
var inst_17653 = inst_17677;
var inst_17654 = inst_17676;
var inst_17655 = inst_17678;
var inst_17656 = (0);
var state_17713__$1 = (function (){var statearr_17748 = state_17713;
(statearr_17748[(20)] = inst_17653);

(statearr_17748[(10)] = inst_17656);

(statearr_17748[(12)] = inst_17654);

(statearr_17748[(21)] = inst_17655);

return statearr_17748;
})();
var statearr_17749_17818 = state_17713__$1;
(statearr_17749_17818[(2)] = null);

(statearr_17749_17818[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (41))){
var inst_17672 = (state_17713[(25)]);
var inst_17688 = (state_17713[(2)]);
var inst_17689 = cljs.core.next.call(null,inst_17672);
var inst_17653 = inst_17689;
var inst_17654 = null;
var inst_17655 = (0);
var inst_17656 = (0);
var state_17713__$1 = (function (){var statearr_17750 = state_17713;
(statearr_17750[(20)] = inst_17653);

(statearr_17750[(10)] = inst_17656);

(statearr_17750[(12)] = inst_17654);

(statearr_17750[(21)] = inst_17655);

(statearr_17750[(27)] = inst_17688);

return statearr_17750;
})();
var statearr_17751_17819 = state_17713__$1;
(statearr_17751_17819[(2)] = null);

(statearr_17751_17819[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (43))){
var state_17713__$1 = state_17713;
var statearr_17752_17820 = state_17713__$1;
(statearr_17752_17820[(2)] = null);

(statearr_17752_17820[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (29))){
var inst_17697 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17753_17821 = state_17713__$1;
(statearr_17753_17821[(2)] = inst_17697);

(statearr_17753_17821[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (44))){
var inst_17706 = (state_17713[(2)]);
var state_17713__$1 = (function (){var statearr_17754 = state_17713;
(statearr_17754[(28)] = inst_17706);

return statearr_17754;
})();
var statearr_17755_17822 = state_17713__$1;
(statearr_17755_17822[(2)] = null);

(statearr_17755_17822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (6))){
var inst_17645 = (state_17713[(29)]);
var inst_17644 = cljs.core.deref.call(null,cs);
var inst_17645__$1 = cljs.core.keys.call(null,inst_17644);
var inst_17646 = cljs.core.count.call(null,inst_17645__$1);
var inst_17647 = cljs.core.reset_BANG_.call(null,dctr,inst_17646);
var inst_17652 = cljs.core.seq.call(null,inst_17645__$1);
var inst_17653 = inst_17652;
var inst_17654 = null;
var inst_17655 = (0);
var inst_17656 = (0);
var state_17713__$1 = (function (){var statearr_17756 = state_17713;
(statearr_17756[(20)] = inst_17653);

(statearr_17756[(30)] = inst_17647);

(statearr_17756[(10)] = inst_17656);

(statearr_17756[(29)] = inst_17645__$1);

(statearr_17756[(12)] = inst_17654);

(statearr_17756[(21)] = inst_17655);

return statearr_17756;
})();
var statearr_17757_17823 = state_17713__$1;
(statearr_17757_17823[(2)] = null);

(statearr_17757_17823[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (28))){
var inst_17653 = (state_17713[(20)]);
var inst_17672 = (state_17713[(25)]);
var inst_17672__$1 = cljs.core.seq.call(null,inst_17653);
var state_17713__$1 = (function (){var statearr_17758 = state_17713;
(statearr_17758[(25)] = inst_17672__$1);

return statearr_17758;
})();
if(inst_17672__$1){
var statearr_17759_17824 = state_17713__$1;
(statearr_17759_17824[(1)] = (33));

} else {
var statearr_17760_17825 = state_17713__$1;
(statearr_17760_17825[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (25))){
var inst_17656 = (state_17713[(10)]);
var inst_17655 = (state_17713[(21)]);
var inst_17658 = (inst_17656 < inst_17655);
var inst_17659 = inst_17658;
var state_17713__$1 = state_17713;
if(cljs.core.truth_(inst_17659)){
var statearr_17761_17826 = state_17713__$1;
(statearr_17761_17826[(1)] = (27));

} else {
var statearr_17762_17827 = state_17713__$1;
(statearr_17762_17827[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (34))){
var state_17713__$1 = state_17713;
var statearr_17763_17828 = state_17713__$1;
(statearr_17763_17828[(2)] = null);

(statearr_17763_17828[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (17))){
var state_17713__$1 = state_17713;
var statearr_17764_17829 = state_17713__$1;
(statearr_17764_17829[(2)] = null);

(statearr_17764_17829[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (3))){
var inst_17711 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17713__$1,inst_17711);
} else {
if((state_val_17714 === (12))){
var inst_17640 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17765_17830 = state_17713__$1;
(statearr_17765_17830[(2)] = inst_17640);

(statearr_17765_17830[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (2))){
var state_17713__$1 = state_17713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17713__$1,(4),ch);
} else {
if((state_val_17714 === (23))){
var state_17713__$1 = state_17713;
var statearr_17766_17831 = state_17713__$1;
(statearr_17766_17831[(2)] = null);

(statearr_17766_17831[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (35))){
var inst_17695 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17767_17832 = state_17713__$1;
(statearr_17767_17832[(2)] = inst_17695);

(statearr_17767_17832[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (19))){
var inst_17612 = (state_17713[(7)]);
var inst_17616 = cljs.core.chunk_first.call(null,inst_17612);
var inst_17617 = cljs.core.chunk_rest.call(null,inst_17612);
var inst_17618 = cljs.core.count.call(null,inst_17616);
var inst_17590 = inst_17617;
var inst_17591 = inst_17616;
var inst_17592 = inst_17618;
var inst_17593 = (0);
var state_17713__$1 = (function (){var statearr_17768 = state_17713;
(statearr_17768[(13)] = inst_17593);

(statearr_17768[(15)] = inst_17591);

(statearr_17768[(16)] = inst_17592);

(statearr_17768[(17)] = inst_17590);

return statearr_17768;
})();
var statearr_17769_17833 = state_17713__$1;
(statearr_17769_17833[(2)] = null);

(statearr_17769_17833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (11))){
var inst_17612 = (state_17713[(7)]);
var inst_17590 = (state_17713[(17)]);
var inst_17612__$1 = cljs.core.seq.call(null,inst_17590);
var state_17713__$1 = (function (){var statearr_17770 = state_17713;
(statearr_17770[(7)] = inst_17612__$1);

return statearr_17770;
})();
if(inst_17612__$1){
var statearr_17771_17834 = state_17713__$1;
(statearr_17771_17834[(1)] = (16));

} else {
var statearr_17772_17835 = state_17713__$1;
(statearr_17772_17835[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (9))){
var inst_17642 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17773_17836 = state_17713__$1;
(statearr_17773_17836[(2)] = inst_17642);

(statearr_17773_17836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (5))){
var inst_17588 = cljs.core.deref.call(null,cs);
var inst_17589 = cljs.core.seq.call(null,inst_17588);
var inst_17590 = inst_17589;
var inst_17591 = null;
var inst_17592 = (0);
var inst_17593 = (0);
var state_17713__$1 = (function (){var statearr_17774 = state_17713;
(statearr_17774[(13)] = inst_17593);

(statearr_17774[(15)] = inst_17591);

(statearr_17774[(16)] = inst_17592);

(statearr_17774[(17)] = inst_17590);

return statearr_17774;
})();
var statearr_17775_17837 = state_17713__$1;
(statearr_17775_17837[(2)] = null);

(statearr_17775_17837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (14))){
var state_17713__$1 = state_17713;
var statearr_17776_17838 = state_17713__$1;
(statearr_17776_17838[(2)] = null);

(statearr_17776_17838[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (45))){
var inst_17703 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17777_17839 = state_17713__$1;
(statearr_17777_17839[(2)] = inst_17703);

(statearr_17777_17839[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (26))){
var inst_17645 = (state_17713[(29)]);
var inst_17699 = (state_17713[(2)]);
var inst_17700 = cljs.core.seq.call(null,inst_17645);
var state_17713__$1 = (function (){var statearr_17778 = state_17713;
(statearr_17778[(31)] = inst_17699);

return statearr_17778;
})();
if(inst_17700){
var statearr_17779_17840 = state_17713__$1;
(statearr_17779_17840[(1)] = (42));

} else {
var statearr_17780_17841 = state_17713__$1;
(statearr_17780_17841[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (16))){
var inst_17612 = (state_17713[(7)]);
var inst_17614 = cljs.core.chunked_seq_QMARK_.call(null,inst_17612);
var state_17713__$1 = state_17713;
if(inst_17614){
var statearr_17781_17842 = state_17713__$1;
(statearr_17781_17842[(1)] = (19));

} else {
var statearr_17782_17843 = state_17713__$1;
(statearr_17782_17843[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (38))){
var inst_17692 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17783_17844 = state_17713__$1;
(statearr_17783_17844[(2)] = inst_17692);

(statearr_17783_17844[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (30))){
var state_17713__$1 = state_17713;
var statearr_17784_17845 = state_17713__$1;
(statearr_17784_17845[(2)] = null);

(statearr_17784_17845[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (10))){
var inst_17593 = (state_17713[(13)]);
var inst_17591 = (state_17713[(15)]);
var inst_17601 = cljs.core._nth.call(null,inst_17591,inst_17593);
var inst_17602 = cljs.core.nth.call(null,inst_17601,(0),null);
var inst_17603 = cljs.core.nth.call(null,inst_17601,(1),null);
var state_17713__$1 = (function (){var statearr_17785 = state_17713;
(statearr_17785[(26)] = inst_17602);

return statearr_17785;
})();
if(cljs.core.truth_(inst_17603)){
var statearr_17786_17846 = state_17713__$1;
(statearr_17786_17846[(1)] = (13));

} else {
var statearr_17787_17847 = state_17713__$1;
(statearr_17787_17847[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (18))){
var inst_17638 = (state_17713[(2)]);
var state_17713__$1 = state_17713;
var statearr_17788_17848 = state_17713__$1;
(statearr_17788_17848[(2)] = inst_17638);

(statearr_17788_17848[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (42))){
var state_17713__$1 = state_17713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17713__$1,(45),dchan);
} else {
if((state_val_17714 === (37))){
var inst_17681 = (state_17713[(23)]);
var inst_17581 = (state_17713[(11)]);
var inst_17672 = (state_17713[(25)]);
var inst_17681__$1 = cljs.core.first.call(null,inst_17672);
var inst_17682 = cljs.core.async.put_BANG_.call(null,inst_17681__$1,inst_17581,done);
var state_17713__$1 = (function (){var statearr_17789 = state_17713;
(statearr_17789[(23)] = inst_17681__$1);

return statearr_17789;
})();
if(cljs.core.truth_(inst_17682)){
var statearr_17790_17849 = state_17713__$1;
(statearr_17790_17849[(1)] = (39));

} else {
var statearr_17791_17850 = state_17713__$1;
(statearr_17791_17850[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17714 === (8))){
var inst_17593 = (state_17713[(13)]);
var inst_17592 = (state_17713[(16)]);
var inst_17595 = (inst_17593 < inst_17592);
var inst_17596 = inst_17595;
var state_17713__$1 = state_17713;
if(cljs.core.truth_(inst_17596)){
var statearr_17792_17851 = state_17713__$1;
(statearr_17792_17851[(1)] = (10));

} else {
var statearr_17793_17852 = state_17713__$1;
(statearr_17793_17852[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___17798,cs,m,dchan,dctr,done))
;
return ((function (switch__16884__auto__,c__16979__auto___17798,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16885__auto__ = null;
var cljs$core$async$mult_$_state_machine__16885__auto____0 = (function (){
var statearr_17794 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17794[(0)] = cljs$core$async$mult_$_state_machine__16885__auto__);

(statearr_17794[(1)] = (1));

return statearr_17794;
});
var cljs$core$async$mult_$_state_machine__16885__auto____1 = (function (state_17713){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e17795){if((e17795 instanceof Object)){
var ex__16888__auto__ = e17795;
var statearr_17796_17853 = state_17713;
(statearr_17796_17853[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17713);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17795;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17854 = state_17713;
state_17713 = G__17854;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16885__auto__ = function(state_17713){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16885__auto____1.call(this,state_17713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16885__auto____0;
cljs$core$async$mult_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16885__auto____1;
return cljs$core$async$mult_$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___17798,cs,m,dchan,dctr,done))
})();
var state__16981__auto__ = (function (){var statearr_17797 = f__16980__auto__.call(null);
(statearr_17797[(6)] = c__16979__auto___17798);

return statearr_17797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___17798,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17856 = arguments.length;
switch (G__17856) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___17868 = arguments.length;
var i__4731__auto___17869 = (0);
while(true){
if((i__4731__auto___17869 < len__4730__auto___17868)){
args__4736__auto__.push((arguments[i__4731__auto___17869]));

var G__17870 = (i__4731__auto___17869 + (1));
i__4731__auto___17869 = G__17870;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17862){
var map__17863 = p__17862;
var map__17863__$1 = (((((!((map__17863 == null))))?(((((map__17863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17863.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17863):map__17863);
var opts = map__17863__$1;
var statearr_17865_17871 = state;
(statearr_17865_17871[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__17863,map__17863__$1,opts){
return (function (val){
var statearr_17866_17872 = state;
(statearr_17866_17872[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__17863,map__17863__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17867_17873 = state;
(statearr_17867_17873[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17858){
var G__17859 = cljs.core.first.call(null,seq17858);
var seq17858__$1 = cljs.core.next.call(null,seq17858);
var G__17860 = cljs.core.first.call(null,seq17858__$1);
var seq17858__$2 = cljs.core.next.call(null,seq17858__$1);
var G__17861 = cljs.core.first.call(null,seq17858__$2);
var seq17858__$3 = cljs.core.next.call(null,seq17858__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17859,G__17860,G__17861,seq17858__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17874 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17874 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17875){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17875 = meta17875;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17876,meta17875__$1){
var self__ = this;
var _17876__$1 = this;
return (new cljs.core.async.t_cljs$core$async17874(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17875__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17876){
var self__ = this;
var _17876__$1 = this;
return self__.meta17875;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta17875","meta17875",-349211629,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17874.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17874.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17874";

cljs.core.async.t_cljs$core$async17874.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async17874");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17874.
 */
cljs.core.async.__GT_t_cljs$core$async17874 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17874(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17875){
return (new cljs.core.async.t_cljs$core$async17874(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17875));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17874(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16979__auto___18038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18038,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18038,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_17978){
var state_val_17979 = (state_17978[(1)]);
if((state_val_17979 === (7))){
var inst_17893 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
var statearr_17980_18039 = state_17978__$1;
(statearr_17980_18039[(2)] = inst_17893);

(statearr_17980_18039[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (20))){
var inst_17905 = (state_17978[(7)]);
var state_17978__$1 = state_17978;
var statearr_17981_18040 = state_17978__$1;
(statearr_17981_18040[(2)] = inst_17905);

(statearr_17981_18040[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (27))){
var state_17978__$1 = state_17978;
var statearr_17982_18041 = state_17978__$1;
(statearr_17982_18041[(2)] = null);

(statearr_17982_18041[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (1))){
var inst_17880 = (state_17978[(8)]);
var inst_17880__$1 = calc_state.call(null);
var inst_17882 = (inst_17880__$1 == null);
var inst_17883 = cljs.core.not.call(null,inst_17882);
var state_17978__$1 = (function (){var statearr_17983 = state_17978;
(statearr_17983[(8)] = inst_17880__$1);

return statearr_17983;
})();
if(inst_17883){
var statearr_17984_18042 = state_17978__$1;
(statearr_17984_18042[(1)] = (2));

} else {
var statearr_17985_18043 = state_17978__$1;
(statearr_17985_18043[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (24))){
var inst_17938 = (state_17978[(9)]);
var inst_17929 = (state_17978[(10)]);
var inst_17952 = (state_17978[(11)]);
var inst_17952__$1 = inst_17929.call(null,inst_17938);
var state_17978__$1 = (function (){var statearr_17986 = state_17978;
(statearr_17986[(11)] = inst_17952__$1);

return statearr_17986;
})();
if(cljs.core.truth_(inst_17952__$1)){
var statearr_17987_18044 = state_17978__$1;
(statearr_17987_18044[(1)] = (29));

} else {
var statearr_17988_18045 = state_17978__$1;
(statearr_17988_18045[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (4))){
var inst_17896 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17896)){
var statearr_17989_18046 = state_17978__$1;
(statearr_17989_18046[(1)] = (8));

} else {
var statearr_17990_18047 = state_17978__$1;
(statearr_17990_18047[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (15))){
var inst_17923 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17923)){
var statearr_17991_18048 = state_17978__$1;
(statearr_17991_18048[(1)] = (19));

} else {
var statearr_17992_18049 = state_17978__$1;
(statearr_17992_18049[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (21))){
var inst_17928 = (state_17978[(12)]);
var inst_17928__$1 = (state_17978[(2)]);
var inst_17929 = cljs.core.get.call(null,inst_17928__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_17930 = cljs.core.get.call(null,inst_17928__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_17931 = cljs.core.get.call(null,inst_17928__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_17978__$1 = (function (){var statearr_17993 = state_17978;
(statearr_17993[(12)] = inst_17928__$1);

(statearr_17993[(13)] = inst_17930);

(statearr_17993[(10)] = inst_17929);

return statearr_17993;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_17978__$1,(22),inst_17931);
} else {
if((state_val_17979 === (31))){
var inst_17960 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17960)){
var statearr_17994_18050 = state_17978__$1;
(statearr_17994_18050[(1)] = (32));

} else {
var statearr_17995_18051 = state_17978__$1;
(statearr_17995_18051[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (32))){
var inst_17937 = (state_17978[(14)]);
var state_17978__$1 = state_17978;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17978__$1,(35),out,inst_17937);
} else {
if((state_val_17979 === (33))){
var inst_17928 = (state_17978[(12)]);
var inst_17905 = inst_17928;
var state_17978__$1 = (function (){var statearr_17996 = state_17978;
(statearr_17996[(7)] = inst_17905);

return statearr_17996;
})();
var statearr_17997_18052 = state_17978__$1;
(statearr_17997_18052[(2)] = null);

(statearr_17997_18052[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (13))){
var inst_17905 = (state_17978[(7)]);
var inst_17912 = inst_17905.cljs$lang$protocol_mask$partition0$;
var inst_17913 = (inst_17912 & (64));
var inst_17914 = inst_17905.cljs$core$ISeq$;
var inst_17915 = (cljs.core.PROTOCOL_SENTINEL === inst_17914);
var inst_17916 = ((inst_17913) || (inst_17915));
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17916)){
var statearr_17998_18053 = state_17978__$1;
(statearr_17998_18053[(1)] = (16));

} else {
var statearr_17999_18054 = state_17978__$1;
(statearr_17999_18054[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (22))){
var inst_17937 = (state_17978[(14)]);
var inst_17938 = (state_17978[(9)]);
var inst_17936 = (state_17978[(2)]);
var inst_17937__$1 = cljs.core.nth.call(null,inst_17936,(0),null);
var inst_17938__$1 = cljs.core.nth.call(null,inst_17936,(1),null);
var inst_17939 = (inst_17937__$1 == null);
var inst_17940 = cljs.core._EQ_.call(null,inst_17938__$1,change);
var inst_17941 = ((inst_17939) || (inst_17940));
var state_17978__$1 = (function (){var statearr_18000 = state_17978;
(statearr_18000[(14)] = inst_17937__$1);

(statearr_18000[(9)] = inst_17938__$1);

return statearr_18000;
})();
if(cljs.core.truth_(inst_17941)){
var statearr_18001_18055 = state_17978__$1;
(statearr_18001_18055[(1)] = (23));

} else {
var statearr_18002_18056 = state_17978__$1;
(statearr_18002_18056[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (36))){
var inst_17928 = (state_17978[(12)]);
var inst_17905 = inst_17928;
var state_17978__$1 = (function (){var statearr_18003 = state_17978;
(statearr_18003[(7)] = inst_17905);

return statearr_18003;
})();
var statearr_18004_18057 = state_17978__$1;
(statearr_18004_18057[(2)] = null);

(statearr_18004_18057[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (29))){
var inst_17952 = (state_17978[(11)]);
var state_17978__$1 = state_17978;
var statearr_18005_18058 = state_17978__$1;
(statearr_18005_18058[(2)] = inst_17952);

(statearr_18005_18058[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (6))){
var state_17978__$1 = state_17978;
var statearr_18006_18059 = state_17978__$1;
(statearr_18006_18059[(2)] = false);

(statearr_18006_18059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (28))){
var inst_17948 = (state_17978[(2)]);
var inst_17949 = calc_state.call(null);
var inst_17905 = inst_17949;
var state_17978__$1 = (function (){var statearr_18007 = state_17978;
(statearr_18007[(7)] = inst_17905);

(statearr_18007[(15)] = inst_17948);

return statearr_18007;
})();
var statearr_18008_18060 = state_17978__$1;
(statearr_18008_18060[(2)] = null);

(statearr_18008_18060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (25))){
var inst_17974 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
var statearr_18009_18061 = state_17978__$1;
(statearr_18009_18061[(2)] = inst_17974);

(statearr_18009_18061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (34))){
var inst_17972 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
var statearr_18010_18062 = state_17978__$1;
(statearr_18010_18062[(2)] = inst_17972);

(statearr_18010_18062[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (17))){
var state_17978__$1 = state_17978;
var statearr_18011_18063 = state_17978__$1;
(statearr_18011_18063[(2)] = false);

(statearr_18011_18063[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (3))){
var state_17978__$1 = state_17978;
var statearr_18012_18064 = state_17978__$1;
(statearr_18012_18064[(2)] = false);

(statearr_18012_18064[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (12))){
var inst_17976 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17978__$1,inst_17976);
} else {
if((state_val_17979 === (2))){
var inst_17880 = (state_17978[(8)]);
var inst_17885 = inst_17880.cljs$lang$protocol_mask$partition0$;
var inst_17886 = (inst_17885 & (64));
var inst_17887 = inst_17880.cljs$core$ISeq$;
var inst_17888 = (cljs.core.PROTOCOL_SENTINEL === inst_17887);
var inst_17889 = ((inst_17886) || (inst_17888));
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17889)){
var statearr_18013_18065 = state_17978__$1;
(statearr_18013_18065[(1)] = (5));

} else {
var statearr_18014_18066 = state_17978__$1;
(statearr_18014_18066[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (23))){
var inst_17937 = (state_17978[(14)]);
var inst_17943 = (inst_17937 == null);
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17943)){
var statearr_18015_18067 = state_17978__$1;
(statearr_18015_18067[(1)] = (26));

} else {
var statearr_18016_18068 = state_17978__$1;
(statearr_18016_18068[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (35))){
var inst_17963 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17963)){
var statearr_18017_18069 = state_17978__$1;
(statearr_18017_18069[(1)] = (36));

} else {
var statearr_18018_18070 = state_17978__$1;
(statearr_18018_18070[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (19))){
var inst_17905 = (state_17978[(7)]);
var inst_17925 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17905);
var state_17978__$1 = state_17978;
var statearr_18019_18071 = state_17978__$1;
(statearr_18019_18071[(2)] = inst_17925);

(statearr_18019_18071[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (11))){
var inst_17905 = (state_17978[(7)]);
var inst_17909 = (inst_17905 == null);
var inst_17910 = cljs.core.not.call(null,inst_17909);
var state_17978__$1 = state_17978;
if(inst_17910){
var statearr_18020_18072 = state_17978__$1;
(statearr_18020_18072[(1)] = (13));

} else {
var statearr_18021_18073 = state_17978__$1;
(statearr_18021_18073[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (9))){
var inst_17880 = (state_17978[(8)]);
var state_17978__$1 = state_17978;
var statearr_18022_18074 = state_17978__$1;
(statearr_18022_18074[(2)] = inst_17880);

(statearr_18022_18074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (5))){
var state_17978__$1 = state_17978;
var statearr_18023_18075 = state_17978__$1;
(statearr_18023_18075[(2)] = true);

(statearr_18023_18075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (14))){
var state_17978__$1 = state_17978;
var statearr_18024_18076 = state_17978__$1;
(statearr_18024_18076[(2)] = false);

(statearr_18024_18076[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (26))){
var inst_17938 = (state_17978[(9)]);
var inst_17945 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_17938);
var state_17978__$1 = state_17978;
var statearr_18025_18077 = state_17978__$1;
(statearr_18025_18077[(2)] = inst_17945);

(statearr_18025_18077[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (16))){
var state_17978__$1 = state_17978;
var statearr_18026_18078 = state_17978__$1;
(statearr_18026_18078[(2)] = true);

(statearr_18026_18078[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (38))){
var inst_17968 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
var statearr_18027_18079 = state_17978__$1;
(statearr_18027_18079[(2)] = inst_17968);

(statearr_18027_18079[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (30))){
var inst_17938 = (state_17978[(9)]);
var inst_17930 = (state_17978[(13)]);
var inst_17929 = (state_17978[(10)]);
var inst_17955 = cljs.core.empty_QMARK_.call(null,inst_17929);
var inst_17956 = inst_17930.call(null,inst_17938);
var inst_17957 = cljs.core.not.call(null,inst_17956);
var inst_17958 = ((inst_17955) && (inst_17957));
var state_17978__$1 = state_17978;
var statearr_18028_18080 = state_17978__$1;
(statearr_18028_18080[(2)] = inst_17958);

(statearr_18028_18080[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (10))){
var inst_17880 = (state_17978[(8)]);
var inst_17901 = (state_17978[(2)]);
var inst_17902 = cljs.core.get.call(null,inst_17901,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_17903 = cljs.core.get.call(null,inst_17901,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_17904 = cljs.core.get.call(null,inst_17901,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_17905 = inst_17880;
var state_17978__$1 = (function (){var statearr_18029 = state_17978;
(statearr_18029[(16)] = inst_17902);

(statearr_18029[(7)] = inst_17905);

(statearr_18029[(17)] = inst_17903);

(statearr_18029[(18)] = inst_17904);

return statearr_18029;
})();
var statearr_18030_18081 = state_17978__$1;
(statearr_18030_18081[(2)] = null);

(statearr_18030_18081[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (18))){
var inst_17920 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
var statearr_18031_18082 = state_17978__$1;
(statearr_18031_18082[(2)] = inst_17920);

(statearr_18031_18082[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (37))){
var state_17978__$1 = state_17978;
var statearr_18032_18083 = state_17978__$1;
(statearr_18032_18083[(2)] = null);

(statearr_18032_18083[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (8))){
var inst_17880 = (state_17978[(8)]);
var inst_17898 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17880);
var state_17978__$1 = state_17978;
var statearr_18033_18084 = state_17978__$1;
(statearr_18033_18084[(2)] = inst_17898);

(statearr_18033_18084[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18038,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16884__auto__,c__16979__auto___18038,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16885__auto__ = null;
var cljs$core$async$mix_$_state_machine__16885__auto____0 = (function (){
var statearr_18034 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18034[(0)] = cljs$core$async$mix_$_state_machine__16885__auto__);

(statearr_18034[(1)] = (1));

return statearr_18034;
});
var cljs$core$async$mix_$_state_machine__16885__auto____1 = (function (state_17978){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_17978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18035){if((e18035 instanceof Object)){
var ex__16888__auto__ = e18035;
var statearr_18036_18085 = state_17978;
(statearr_18036_18085[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17978);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18035;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18086 = state_17978;
state_17978 = G__18086;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16885__auto__ = function(state_17978){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16885__auto____1.call(this,state_17978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16885__auto____0;
cljs$core$async$mix_$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16885__auto____1;
return cljs$core$async$mix_$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18038,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16981__auto__ = (function (){var statearr_18037 = f__16980__auto__.call(null);
(statearr_18037[(6)] = c__16979__auto___18038);

return statearr_18037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18038,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18088 = arguments.length;
switch (G__18088) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18092 = arguments.length;
switch (G__18092) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__18090_SHARP_){
if(cljs.core.truth_(p1__18090_SHARP_.call(null,topic))){
return p1__18090_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__18090_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18093 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18093 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18094){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18094 = meta18094;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18095,meta18094__$1){
var self__ = this;
var _18095__$1 = this;
return (new cljs.core.async.t_cljs$core$async18093(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18094__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18095){
var self__ = this;
var _18095__$1 = this;
return self__.meta18094;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta18094","meta18094",-1343089100,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18093.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18093.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18093";

cljs.core.async.t_cljs$core$async18093.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async18093");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18093.
 */
cljs.core.async.__GT_t_cljs$core$async18093 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18093(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18094){
return (new cljs.core.async.t_cljs$core$async18093(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18094));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18093(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16979__auto___18213 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18213,mults,ensure_mult,p){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18213,mults,ensure_mult,p){
return (function (state_18167){
var state_val_18168 = (state_18167[(1)]);
if((state_val_18168 === (7))){
var inst_18163 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
var statearr_18169_18214 = state_18167__$1;
(statearr_18169_18214[(2)] = inst_18163);

(statearr_18169_18214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (20))){
var state_18167__$1 = state_18167;
var statearr_18170_18215 = state_18167__$1;
(statearr_18170_18215[(2)] = null);

(statearr_18170_18215[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (1))){
var state_18167__$1 = state_18167;
var statearr_18171_18216 = state_18167__$1;
(statearr_18171_18216[(2)] = null);

(statearr_18171_18216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (24))){
var inst_18146 = (state_18167[(7)]);
var inst_18155 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_18146);
var state_18167__$1 = state_18167;
var statearr_18172_18217 = state_18167__$1;
(statearr_18172_18217[(2)] = inst_18155);

(statearr_18172_18217[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (4))){
var inst_18098 = (state_18167[(8)]);
var inst_18098__$1 = (state_18167[(2)]);
var inst_18099 = (inst_18098__$1 == null);
var state_18167__$1 = (function (){var statearr_18173 = state_18167;
(statearr_18173[(8)] = inst_18098__$1);

return statearr_18173;
})();
if(cljs.core.truth_(inst_18099)){
var statearr_18174_18218 = state_18167__$1;
(statearr_18174_18218[(1)] = (5));

} else {
var statearr_18175_18219 = state_18167__$1;
(statearr_18175_18219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (15))){
var inst_18140 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
var statearr_18176_18220 = state_18167__$1;
(statearr_18176_18220[(2)] = inst_18140);

(statearr_18176_18220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (21))){
var inst_18160 = (state_18167[(2)]);
var state_18167__$1 = (function (){var statearr_18177 = state_18167;
(statearr_18177[(9)] = inst_18160);

return statearr_18177;
})();
var statearr_18178_18221 = state_18167__$1;
(statearr_18178_18221[(2)] = null);

(statearr_18178_18221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (13))){
var inst_18122 = (state_18167[(10)]);
var inst_18124 = cljs.core.chunked_seq_QMARK_.call(null,inst_18122);
var state_18167__$1 = state_18167;
if(inst_18124){
var statearr_18179_18222 = state_18167__$1;
(statearr_18179_18222[(1)] = (16));

} else {
var statearr_18180_18223 = state_18167__$1;
(statearr_18180_18223[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (22))){
var inst_18152 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
if(cljs.core.truth_(inst_18152)){
var statearr_18181_18224 = state_18167__$1;
(statearr_18181_18224[(1)] = (23));

} else {
var statearr_18182_18225 = state_18167__$1;
(statearr_18182_18225[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (6))){
var inst_18148 = (state_18167[(11)]);
var inst_18146 = (state_18167[(7)]);
var inst_18098 = (state_18167[(8)]);
var inst_18146__$1 = topic_fn.call(null,inst_18098);
var inst_18147 = cljs.core.deref.call(null,mults);
var inst_18148__$1 = cljs.core.get.call(null,inst_18147,inst_18146__$1);
var state_18167__$1 = (function (){var statearr_18183 = state_18167;
(statearr_18183[(11)] = inst_18148__$1);

(statearr_18183[(7)] = inst_18146__$1);

return statearr_18183;
})();
if(cljs.core.truth_(inst_18148__$1)){
var statearr_18184_18226 = state_18167__$1;
(statearr_18184_18226[(1)] = (19));

} else {
var statearr_18185_18227 = state_18167__$1;
(statearr_18185_18227[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (25))){
var inst_18157 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
var statearr_18186_18228 = state_18167__$1;
(statearr_18186_18228[(2)] = inst_18157);

(statearr_18186_18228[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (17))){
var inst_18122 = (state_18167[(10)]);
var inst_18131 = cljs.core.first.call(null,inst_18122);
var inst_18132 = cljs.core.async.muxch_STAR_.call(null,inst_18131);
var inst_18133 = cljs.core.async.close_BANG_.call(null,inst_18132);
var inst_18134 = cljs.core.next.call(null,inst_18122);
var inst_18108 = inst_18134;
var inst_18109 = null;
var inst_18110 = (0);
var inst_18111 = (0);
var state_18167__$1 = (function (){var statearr_18187 = state_18167;
(statearr_18187[(12)] = inst_18110);

(statearr_18187[(13)] = inst_18108);

(statearr_18187[(14)] = inst_18133);

(statearr_18187[(15)] = inst_18111);

(statearr_18187[(16)] = inst_18109);

return statearr_18187;
})();
var statearr_18188_18229 = state_18167__$1;
(statearr_18188_18229[(2)] = null);

(statearr_18188_18229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (3))){
var inst_18165 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18167__$1,inst_18165);
} else {
if((state_val_18168 === (12))){
var inst_18142 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
var statearr_18189_18230 = state_18167__$1;
(statearr_18189_18230[(2)] = inst_18142);

(statearr_18189_18230[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (2))){
var state_18167__$1 = state_18167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18167__$1,(4),ch);
} else {
if((state_val_18168 === (23))){
var state_18167__$1 = state_18167;
var statearr_18190_18231 = state_18167__$1;
(statearr_18190_18231[(2)] = null);

(statearr_18190_18231[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (19))){
var inst_18148 = (state_18167[(11)]);
var inst_18098 = (state_18167[(8)]);
var inst_18150 = cljs.core.async.muxch_STAR_.call(null,inst_18148);
var state_18167__$1 = state_18167;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18167__$1,(22),inst_18150,inst_18098);
} else {
if((state_val_18168 === (11))){
var inst_18108 = (state_18167[(13)]);
var inst_18122 = (state_18167[(10)]);
var inst_18122__$1 = cljs.core.seq.call(null,inst_18108);
var state_18167__$1 = (function (){var statearr_18191 = state_18167;
(statearr_18191[(10)] = inst_18122__$1);

return statearr_18191;
})();
if(inst_18122__$1){
var statearr_18192_18232 = state_18167__$1;
(statearr_18192_18232[(1)] = (13));

} else {
var statearr_18193_18233 = state_18167__$1;
(statearr_18193_18233[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (9))){
var inst_18144 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
var statearr_18194_18234 = state_18167__$1;
(statearr_18194_18234[(2)] = inst_18144);

(statearr_18194_18234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (5))){
var inst_18105 = cljs.core.deref.call(null,mults);
var inst_18106 = cljs.core.vals.call(null,inst_18105);
var inst_18107 = cljs.core.seq.call(null,inst_18106);
var inst_18108 = inst_18107;
var inst_18109 = null;
var inst_18110 = (0);
var inst_18111 = (0);
var state_18167__$1 = (function (){var statearr_18195 = state_18167;
(statearr_18195[(12)] = inst_18110);

(statearr_18195[(13)] = inst_18108);

(statearr_18195[(15)] = inst_18111);

(statearr_18195[(16)] = inst_18109);

return statearr_18195;
})();
var statearr_18196_18235 = state_18167__$1;
(statearr_18196_18235[(2)] = null);

(statearr_18196_18235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (14))){
var state_18167__$1 = state_18167;
var statearr_18200_18236 = state_18167__$1;
(statearr_18200_18236[(2)] = null);

(statearr_18200_18236[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (16))){
var inst_18122 = (state_18167[(10)]);
var inst_18126 = cljs.core.chunk_first.call(null,inst_18122);
var inst_18127 = cljs.core.chunk_rest.call(null,inst_18122);
var inst_18128 = cljs.core.count.call(null,inst_18126);
var inst_18108 = inst_18127;
var inst_18109 = inst_18126;
var inst_18110 = inst_18128;
var inst_18111 = (0);
var state_18167__$1 = (function (){var statearr_18201 = state_18167;
(statearr_18201[(12)] = inst_18110);

(statearr_18201[(13)] = inst_18108);

(statearr_18201[(15)] = inst_18111);

(statearr_18201[(16)] = inst_18109);

return statearr_18201;
})();
var statearr_18202_18237 = state_18167__$1;
(statearr_18202_18237[(2)] = null);

(statearr_18202_18237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (10))){
var inst_18110 = (state_18167[(12)]);
var inst_18108 = (state_18167[(13)]);
var inst_18111 = (state_18167[(15)]);
var inst_18109 = (state_18167[(16)]);
var inst_18116 = cljs.core._nth.call(null,inst_18109,inst_18111);
var inst_18117 = cljs.core.async.muxch_STAR_.call(null,inst_18116);
var inst_18118 = cljs.core.async.close_BANG_.call(null,inst_18117);
var inst_18119 = (inst_18111 + (1));
var tmp18197 = inst_18110;
var tmp18198 = inst_18108;
var tmp18199 = inst_18109;
var inst_18108__$1 = tmp18198;
var inst_18109__$1 = tmp18199;
var inst_18110__$1 = tmp18197;
var inst_18111__$1 = inst_18119;
var state_18167__$1 = (function (){var statearr_18203 = state_18167;
(statearr_18203[(12)] = inst_18110__$1);

(statearr_18203[(17)] = inst_18118);

(statearr_18203[(13)] = inst_18108__$1);

(statearr_18203[(15)] = inst_18111__$1);

(statearr_18203[(16)] = inst_18109__$1);

return statearr_18203;
})();
var statearr_18204_18238 = state_18167__$1;
(statearr_18204_18238[(2)] = null);

(statearr_18204_18238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (18))){
var inst_18137 = (state_18167[(2)]);
var state_18167__$1 = state_18167;
var statearr_18205_18239 = state_18167__$1;
(statearr_18205_18239[(2)] = inst_18137);

(statearr_18205_18239[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18168 === (8))){
var inst_18110 = (state_18167[(12)]);
var inst_18111 = (state_18167[(15)]);
var inst_18113 = (inst_18111 < inst_18110);
var inst_18114 = inst_18113;
var state_18167__$1 = state_18167;
if(cljs.core.truth_(inst_18114)){
var statearr_18206_18240 = state_18167__$1;
(statearr_18206_18240[(1)] = (10));

} else {
var statearr_18207_18241 = state_18167__$1;
(statearr_18207_18241[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18213,mults,ensure_mult,p))
;
return ((function (switch__16884__auto__,c__16979__auto___18213,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18208 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18208[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18208[(1)] = (1));

return statearr_18208;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18167){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18209){if((e18209 instanceof Object)){
var ex__16888__auto__ = e18209;
var statearr_18210_18242 = state_18167;
(statearr_18210_18242[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18167);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18243 = state_18167;
state_18167 = G__18243;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18213,mults,ensure_mult,p))
})();
var state__16981__auto__ = (function (){var statearr_18211 = f__16980__auto__.call(null);
(statearr_18211[(6)] = c__16979__auto___18213);

return statearr_18211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18213,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18245 = arguments.length;
switch (G__18245) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18248 = arguments.length;
switch (G__18248) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18251 = arguments.length;
switch (G__18251) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__16979__auto___18318 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18318,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18318,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18290){
var state_val_18291 = (state_18290[(1)]);
if((state_val_18291 === (7))){
var state_18290__$1 = state_18290;
var statearr_18292_18319 = state_18290__$1;
(statearr_18292_18319[(2)] = null);

(statearr_18292_18319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (1))){
var state_18290__$1 = state_18290;
var statearr_18293_18320 = state_18290__$1;
(statearr_18293_18320[(2)] = null);

(statearr_18293_18320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (4))){
var inst_18254 = (state_18290[(7)]);
var inst_18256 = (inst_18254 < cnt);
var state_18290__$1 = state_18290;
if(cljs.core.truth_(inst_18256)){
var statearr_18294_18321 = state_18290__$1;
(statearr_18294_18321[(1)] = (6));

} else {
var statearr_18295_18322 = state_18290__$1;
(statearr_18295_18322[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (15))){
var inst_18286 = (state_18290[(2)]);
var state_18290__$1 = state_18290;
var statearr_18296_18323 = state_18290__$1;
(statearr_18296_18323[(2)] = inst_18286);

(statearr_18296_18323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (13))){
var inst_18279 = cljs.core.async.close_BANG_.call(null,out);
var state_18290__$1 = state_18290;
var statearr_18297_18324 = state_18290__$1;
(statearr_18297_18324[(2)] = inst_18279);

(statearr_18297_18324[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (6))){
var state_18290__$1 = state_18290;
var statearr_18298_18325 = state_18290__$1;
(statearr_18298_18325[(2)] = null);

(statearr_18298_18325[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (3))){
var inst_18288 = (state_18290[(2)]);
var state_18290__$1 = state_18290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18290__$1,inst_18288);
} else {
if((state_val_18291 === (12))){
var inst_18276 = (state_18290[(8)]);
var inst_18276__$1 = (state_18290[(2)]);
var inst_18277 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_18276__$1);
var state_18290__$1 = (function (){var statearr_18299 = state_18290;
(statearr_18299[(8)] = inst_18276__$1);

return statearr_18299;
})();
if(cljs.core.truth_(inst_18277)){
var statearr_18300_18326 = state_18290__$1;
(statearr_18300_18326[(1)] = (13));

} else {
var statearr_18301_18327 = state_18290__$1;
(statearr_18301_18327[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (2))){
var inst_18253 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_18254 = (0);
var state_18290__$1 = (function (){var statearr_18302 = state_18290;
(statearr_18302[(9)] = inst_18253);

(statearr_18302[(7)] = inst_18254);

return statearr_18302;
})();
var statearr_18303_18328 = state_18290__$1;
(statearr_18303_18328[(2)] = null);

(statearr_18303_18328[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (11))){
var inst_18254 = (state_18290[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_18290,(10),Object,null,(9));
var inst_18263 = chs__$1.call(null,inst_18254);
var inst_18264 = done.call(null,inst_18254);
var inst_18265 = cljs.core.async.take_BANG_.call(null,inst_18263,inst_18264);
var state_18290__$1 = state_18290;
var statearr_18304_18329 = state_18290__$1;
(statearr_18304_18329[(2)] = inst_18265);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18290__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (9))){
var inst_18254 = (state_18290[(7)]);
var inst_18267 = (state_18290[(2)]);
var inst_18268 = (inst_18254 + (1));
var inst_18254__$1 = inst_18268;
var state_18290__$1 = (function (){var statearr_18305 = state_18290;
(statearr_18305[(7)] = inst_18254__$1);

(statearr_18305[(10)] = inst_18267);

return statearr_18305;
})();
var statearr_18306_18330 = state_18290__$1;
(statearr_18306_18330[(2)] = null);

(statearr_18306_18330[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (5))){
var inst_18274 = (state_18290[(2)]);
var state_18290__$1 = (function (){var statearr_18307 = state_18290;
(statearr_18307[(11)] = inst_18274);

return statearr_18307;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18290__$1,(12),dchan);
} else {
if((state_val_18291 === (14))){
var inst_18276 = (state_18290[(8)]);
var inst_18281 = cljs.core.apply.call(null,f,inst_18276);
var state_18290__$1 = state_18290;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18290__$1,(16),out,inst_18281);
} else {
if((state_val_18291 === (16))){
var inst_18283 = (state_18290[(2)]);
var state_18290__$1 = (function (){var statearr_18308 = state_18290;
(statearr_18308[(12)] = inst_18283);

return statearr_18308;
})();
var statearr_18309_18331 = state_18290__$1;
(statearr_18309_18331[(2)] = null);

(statearr_18309_18331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (10))){
var inst_18258 = (state_18290[(2)]);
var inst_18259 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_18290__$1 = (function (){var statearr_18310 = state_18290;
(statearr_18310[(13)] = inst_18258);

return statearr_18310;
})();
var statearr_18311_18332 = state_18290__$1;
(statearr_18311_18332[(2)] = inst_18259);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18290__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18291 === (8))){
var inst_18272 = (state_18290[(2)]);
var state_18290__$1 = state_18290;
var statearr_18312_18333 = state_18290__$1;
(statearr_18312_18333[(2)] = inst_18272);

(statearr_18312_18333[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18318,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16884__auto__,c__16979__auto___18318,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18313 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18313[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18313[(1)] = (1));

return statearr_18313;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18290){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18314){if((e18314 instanceof Object)){
var ex__16888__auto__ = e18314;
var statearr_18315_18334 = state_18290;
(statearr_18315_18334[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18290);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18314;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18335 = state_18290;
state_18290 = G__18335;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18290){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18318,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16981__auto__ = (function (){var statearr_18316 = f__16980__auto__.call(null);
(statearr_18316[(6)] = c__16979__auto___18318);

return statearr_18316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18318,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18338 = arguments.length;
switch (G__18338) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16979__auto___18392 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18392,out){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18392,out){
return (function (state_18370){
var state_val_18371 = (state_18370[(1)]);
if((state_val_18371 === (7))){
var inst_18350 = (state_18370[(7)]);
var inst_18349 = (state_18370[(8)]);
var inst_18349__$1 = (state_18370[(2)]);
var inst_18350__$1 = cljs.core.nth.call(null,inst_18349__$1,(0),null);
var inst_18351 = cljs.core.nth.call(null,inst_18349__$1,(1),null);
var inst_18352 = (inst_18350__$1 == null);
var state_18370__$1 = (function (){var statearr_18372 = state_18370;
(statearr_18372[(7)] = inst_18350__$1);

(statearr_18372[(9)] = inst_18351);

(statearr_18372[(8)] = inst_18349__$1);

return statearr_18372;
})();
if(cljs.core.truth_(inst_18352)){
var statearr_18373_18393 = state_18370__$1;
(statearr_18373_18393[(1)] = (8));

} else {
var statearr_18374_18394 = state_18370__$1;
(statearr_18374_18394[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18371 === (1))){
var inst_18339 = cljs.core.vec.call(null,chs);
var inst_18340 = inst_18339;
var state_18370__$1 = (function (){var statearr_18375 = state_18370;
(statearr_18375[(10)] = inst_18340);

return statearr_18375;
})();
var statearr_18376_18395 = state_18370__$1;
(statearr_18376_18395[(2)] = null);

(statearr_18376_18395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18371 === (4))){
var inst_18340 = (state_18370[(10)]);
var state_18370__$1 = state_18370;
return cljs.core.async.ioc_alts_BANG_.call(null,state_18370__$1,(7),inst_18340);
} else {
if((state_val_18371 === (6))){
var inst_18366 = (state_18370[(2)]);
var state_18370__$1 = state_18370;
var statearr_18377_18396 = state_18370__$1;
(statearr_18377_18396[(2)] = inst_18366);

(statearr_18377_18396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18371 === (3))){
var inst_18368 = (state_18370[(2)]);
var state_18370__$1 = state_18370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18370__$1,inst_18368);
} else {
if((state_val_18371 === (2))){
var inst_18340 = (state_18370[(10)]);
var inst_18342 = cljs.core.count.call(null,inst_18340);
var inst_18343 = (inst_18342 > (0));
var state_18370__$1 = state_18370;
if(cljs.core.truth_(inst_18343)){
var statearr_18379_18397 = state_18370__$1;
(statearr_18379_18397[(1)] = (4));

} else {
var statearr_18380_18398 = state_18370__$1;
(statearr_18380_18398[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18371 === (11))){
var inst_18340 = (state_18370[(10)]);
var inst_18359 = (state_18370[(2)]);
var tmp18378 = inst_18340;
var inst_18340__$1 = tmp18378;
var state_18370__$1 = (function (){var statearr_18381 = state_18370;
(statearr_18381[(11)] = inst_18359);

(statearr_18381[(10)] = inst_18340__$1);

return statearr_18381;
})();
var statearr_18382_18399 = state_18370__$1;
(statearr_18382_18399[(2)] = null);

(statearr_18382_18399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18371 === (9))){
var inst_18350 = (state_18370[(7)]);
var state_18370__$1 = state_18370;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18370__$1,(11),out,inst_18350);
} else {
if((state_val_18371 === (5))){
var inst_18364 = cljs.core.async.close_BANG_.call(null,out);
var state_18370__$1 = state_18370;
var statearr_18383_18400 = state_18370__$1;
(statearr_18383_18400[(2)] = inst_18364);

(statearr_18383_18400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18371 === (10))){
var inst_18362 = (state_18370[(2)]);
var state_18370__$1 = state_18370;
var statearr_18384_18401 = state_18370__$1;
(statearr_18384_18401[(2)] = inst_18362);

(statearr_18384_18401[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18371 === (8))){
var inst_18350 = (state_18370[(7)]);
var inst_18351 = (state_18370[(9)]);
var inst_18340 = (state_18370[(10)]);
var inst_18349 = (state_18370[(8)]);
var inst_18354 = (function (){var cs = inst_18340;
var vec__18345 = inst_18349;
var v = inst_18350;
var c = inst_18351;
return ((function (cs,vec__18345,v,c,inst_18350,inst_18351,inst_18340,inst_18349,state_val_18371,c__16979__auto___18392,out){
return (function (p1__18336_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__18336_SHARP_);
});
;})(cs,vec__18345,v,c,inst_18350,inst_18351,inst_18340,inst_18349,state_val_18371,c__16979__auto___18392,out))
})();
var inst_18355 = cljs.core.filterv.call(null,inst_18354,inst_18340);
var inst_18340__$1 = inst_18355;
var state_18370__$1 = (function (){var statearr_18385 = state_18370;
(statearr_18385[(10)] = inst_18340__$1);

return statearr_18385;
})();
var statearr_18386_18402 = state_18370__$1;
(statearr_18386_18402[(2)] = null);

(statearr_18386_18402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18392,out))
;
return ((function (switch__16884__auto__,c__16979__auto___18392,out){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18387 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18387[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18387[(1)] = (1));

return statearr_18387;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18370){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18388){if((e18388 instanceof Object)){
var ex__16888__auto__ = e18388;
var statearr_18389_18403 = state_18370;
(statearr_18389_18403[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18370);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18388;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18404 = state_18370;
state_18370 = G__18404;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18370){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18392,out))
})();
var state__16981__auto__ = (function (){var statearr_18390 = f__16980__auto__.call(null);
(statearr_18390[(6)] = c__16979__auto___18392);

return statearr_18390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18392,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18406 = arguments.length;
switch (G__18406) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16979__auto___18451 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18451,out){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18451,out){
return (function (state_18430){
var state_val_18431 = (state_18430[(1)]);
if((state_val_18431 === (7))){
var inst_18412 = (state_18430[(7)]);
var inst_18412__$1 = (state_18430[(2)]);
var inst_18413 = (inst_18412__$1 == null);
var inst_18414 = cljs.core.not.call(null,inst_18413);
var state_18430__$1 = (function (){var statearr_18432 = state_18430;
(statearr_18432[(7)] = inst_18412__$1);

return statearr_18432;
})();
if(inst_18414){
var statearr_18433_18452 = state_18430__$1;
(statearr_18433_18452[(1)] = (8));

} else {
var statearr_18434_18453 = state_18430__$1;
(statearr_18434_18453[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (1))){
var inst_18407 = (0);
var state_18430__$1 = (function (){var statearr_18435 = state_18430;
(statearr_18435[(8)] = inst_18407);

return statearr_18435;
})();
var statearr_18436_18454 = state_18430__$1;
(statearr_18436_18454[(2)] = null);

(statearr_18436_18454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (4))){
var state_18430__$1 = state_18430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18430__$1,(7),ch);
} else {
if((state_val_18431 === (6))){
var inst_18425 = (state_18430[(2)]);
var state_18430__$1 = state_18430;
var statearr_18437_18455 = state_18430__$1;
(statearr_18437_18455[(2)] = inst_18425);

(statearr_18437_18455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (3))){
var inst_18427 = (state_18430[(2)]);
var inst_18428 = cljs.core.async.close_BANG_.call(null,out);
var state_18430__$1 = (function (){var statearr_18438 = state_18430;
(statearr_18438[(9)] = inst_18427);

return statearr_18438;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18430__$1,inst_18428);
} else {
if((state_val_18431 === (2))){
var inst_18407 = (state_18430[(8)]);
var inst_18409 = (inst_18407 < n);
var state_18430__$1 = state_18430;
if(cljs.core.truth_(inst_18409)){
var statearr_18439_18456 = state_18430__$1;
(statearr_18439_18456[(1)] = (4));

} else {
var statearr_18440_18457 = state_18430__$1;
(statearr_18440_18457[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (11))){
var inst_18407 = (state_18430[(8)]);
var inst_18417 = (state_18430[(2)]);
var inst_18418 = (inst_18407 + (1));
var inst_18407__$1 = inst_18418;
var state_18430__$1 = (function (){var statearr_18441 = state_18430;
(statearr_18441[(10)] = inst_18417);

(statearr_18441[(8)] = inst_18407__$1);

return statearr_18441;
})();
var statearr_18442_18458 = state_18430__$1;
(statearr_18442_18458[(2)] = null);

(statearr_18442_18458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (9))){
var state_18430__$1 = state_18430;
var statearr_18443_18459 = state_18430__$1;
(statearr_18443_18459[(2)] = null);

(statearr_18443_18459[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (5))){
var state_18430__$1 = state_18430;
var statearr_18444_18460 = state_18430__$1;
(statearr_18444_18460[(2)] = null);

(statearr_18444_18460[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (10))){
var inst_18422 = (state_18430[(2)]);
var state_18430__$1 = state_18430;
var statearr_18445_18461 = state_18430__$1;
(statearr_18445_18461[(2)] = inst_18422);

(statearr_18445_18461[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18431 === (8))){
var inst_18412 = (state_18430[(7)]);
var state_18430__$1 = state_18430;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18430__$1,(11),out,inst_18412);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18451,out))
;
return ((function (switch__16884__auto__,c__16979__auto___18451,out){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18446 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18446[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18446[(1)] = (1));

return statearr_18446;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18430){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18447){if((e18447 instanceof Object)){
var ex__16888__auto__ = e18447;
var statearr_18448_18462 = state_18430;
(statearr_18448_18462[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18447;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18463 = state_18430;
state_18430 = G__18463;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18451,out))
})();
var state__16981__auto__ = (function (){var statearr_18449 = f__16980__auto__.call(null);
(statearr_18449[(6)] = c__16979__auto___18451);

return statearr_18449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18451,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18465 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18465 = (function (f,ch,meta18466){
this.f = f;
this.ch = ch;
this.meta18466 = meta18466;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18467,meta18466__$1){
var self__ = this;
var _18467__$1 = this;
return (new cljs.core.async.t_cljs$core$async18465(self__.f,self__.ch,meta18466__$1));
});

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18467){
var self__ = this;
var _18467__$1 = this;
return self__.meta18466;
});

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18468 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18468 = (function (f,ch,meta18466,_,fn1,meta18469){
this.f = f;
this.ch = ch;
this.meta18466 = meta18466;
this._ = _;
this.fn1 = fn1;
this.meta18469 = meta18469;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18468.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18470,meta18469__$1){
var self__ = this;
var _18470__$1 = this;
return (new cljs.core.async.t_cljs$core$async18468(self__.f,self__.ch,self__.meta18466,self__._,self__.fn1,meta18469__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18468.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18470){
var self__ = this;
var _18470__$1 = this;
return self__.meta18469;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18468.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18468.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18468.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18468.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18464_SHARP_){
return f1.call(null,(((p1__18464_SHARP_ == null))?null:self__.f.call(null,p1__18464_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18468.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18466","meta18466",1235300241,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async18465","cljs.core.async/t_cljs$core$async18465",-1738884854,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta18469","meta18469",-318988748,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18468.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18468.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18468";

cljs.core.async.t_cljs$core$async18468.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async18468");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18468.
 */
cljs.core.async.__GT_t_cljs$core$async18468 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18468(f__$1,ch__$1,meta18466__$1,___$2,fn1__$1,meta18469){
return (new cljs.core.async.t_cljs$core$async18468(f__$1,ch__$1,meta18466__$1,___$2,fn1__$1,meta18469));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18468(self__.f,self__.ch,self__.meta18466,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18465.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18465.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18466","meta18466",1235300241,null)], null);
});

cljs.core.async.t_cljs$core$async18465.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18465.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18465";

cljs.core.async.t_cljs$core$async18465.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async18465");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18465.
 */
cljs.core.async.__GT_t_cljs$core$async18465 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18465(f__$1,ch__$1,meta18466){
return (new cljs.core.async.t_cljs$core$async18465(f__$1,ch__$1,meta18466));
});

}

return (new cljs.core.async.t_cljs$core$async18465(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18471 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18471 = (function (f,ch,meta18472){
this.f = f;
this.ch = ch;
this.meta18472 = meta18472;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18473,meta18472__$1){
var self__ = this;
var _18473__$1 = this;
return (new cljs.core.async.t_cljs$core$async18471(self__.f,self__.ch,meta18472__$1));
});

cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18473){
var self__ = this;
var _18473__$1 = this;
return self__.meta18472;
});

cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18471.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async18471.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18472","meta18472",632580135,null)], null);
});

cljs.core.async.t_cljs$core$async18471.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18471.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18471";

cljs.core.async.t_cljs$core$async18471.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async18471");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18471.
 */
cljs.core.async.__GT_t_cljs$core$async18471 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18471(f__$1,ch__$1,meta18472){
return (new cljs.core.async.t_cljs$core$async18471(f__$1,ch__$1,meta18472));
});

}

return (new cljs.core.async.t_cljs$core$async18471(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18474 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18474 = (function (p,ch,meta18475){
this.p = p;
this.ch = ch;
this.meta18475 = meta18475;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18476,meta18475__$1){
var self__ = this;
var _18476__$1 = this;
return (new cljs.core.async.t_cljs$core$async18474(self__.p,self__.ch,meta18475__$1));
});

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18476){
var self__ = this;
var _18476__$1 = this;
return self__.meta18475;
});

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18474.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18474.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18475","meta18475",-646829589,null)], null);
});

cljs.core.async.t_cljs$core$async18474.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18474.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18474";

cljs.core.async.t_cljs$core$async18474.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async18474");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18474.
 */
cljs.core.async.__GT_t_cljs$core$async18474 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18474(p__$1,ch__$1,meta18475){
return (new cljs.core.async.t_cljs$core$async18474(p__$1,ch__$1,meta18475));
});

}

return (new cljs.core.async.t_cljs$core$async18474(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18478 = arguments.length;
switch (G__18478) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16979__auto___18518 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18518,out){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18518,out){
return (function (state_18499){
var state_val_18500 = (state_18499[(1)]);
if((state_val_18500 === (7))){
var inst_18495 = (state_18499[(2)]);
var state_18499__$1 = state_18499;
var statearr_18501_18519 = state_18499__$1;
(statearr_18501_18519[(2)] = inst_18495);

(statearr_18501_18519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (1))){
var state_18499__$1 = state_18499;
var statearr_18502_18520 = state_18499__$1;
(statearr_18502_18520[(2)] = null);

(statearr_18502_18520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (4))){
var inst_18481 = (state_18499[(7)]);
var inst_18481__$1 = (state_18499[(2)]);
var inst_18482 = (inst_18481__$1 == null);
var state_18499__$1 = (function (){var statearr_18503 = state_18499;
(statearr_18503[(7)] = inst_18481__$1);

return statearr_18503;
})();
if(cljs.core.truth_(inst_18482)){
var statearr_18504_18521 = state_18499__$1;
(statearr_18504_18521[(1)] = (5));

} else {
var statearr_18505_18522 = state_18499__$1;
(statearr_18505_18522[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (6))){
var inst_18481 = (state_18499[(7)]);
var inst_18486 = p.call(null,inst_18481);
var state_18499__$1 = state_18499;
if(cljs.core.truth_(inst_18486)){
var statearr_18506_18523 = state_18499__$1;
(statearr_18506_18523[(1)] = (8));

} else {
var statearr_18507_18524 = state_18499__$1;
(statearr_18507_18524[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (3))){
var inst_18497 = (state_18499[(2)]);
var state_18499__$1 = state_18499;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18499__$1,inst_18497);
} else {
if((state_val_18500 === (2))){
var state_18499__$1 = state_18499;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18499__$1,(4),ch);
} else {
if((state_val_18500 === (11))){
var inst_18489 = (state_18499[(2)]);
var state_18499__$1 = state_18499;
var statearr_18508_18525 = state_18499__$1;
(statearr_18508_18525[(2)] = inst_18489);

(statearr_18508_18525[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (9))){
var state_18499__$1 = state_18499;
var statearr_18509_18526 = state_18499__$1;
(statearr_18509_18526[(2)] = null);

(statearr_18509_18526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (5))){
var inst_18484 = cljs.core.async.close_BANG_.call(null,out);
var state_18499__$1 = state_18499;
var statearr_18510_18527 = state_18499__$1;
(statearr_18510_18527[(2)] = inst_18484);

(statearr_18510_18527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (10))){
var inst_18492 = (state_18499[(2)]);
var state_18499__$1 = (function (){var statearr_18511 = state_18499;
(statearr_18511[(8)] = inst_18492);

return statearr_18511;
})();
var statearr_18512_18528 = state_18499__$1;
(statearr_18512_18528[(2)] = null);

(statearr_18512_18528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18500 === (8))){
var inst_18481 = (state_18499[(7)]);
var state_18499__$1 = state_18499;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18499__$1,(11),out,inst_18481);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18518,out))
;
return ((function (switch__16884__auto__,c__16979__auto___18518,out){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18513 = [null,null,null,null,null,null,null,null,null];
(statearr_18513[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18513[(1)] = (1));

return statearr_18513;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18499){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18514){if((e18514 instanceof Object)){
var ex__16888__auto__ = e18514;
var statearr_18515_18529 = state_18499;
(statearr_18515_18529[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18499);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18514;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18530 = state_18499;
state_18499 = G__18530;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18499){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18518,out))
})();
var state__16981__auto__ = (function (){var statearr_18516 = f__16980__auto__.call(null);
(statearr_18516[(6)] = c__16979__auto___18518);

return statearr_18516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18518,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18532 = arguments.length;
switch (G__18532) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16979__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto__){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto__){
return (function (state_18595){
var state_val_18596 = (state_18595[(1)]);
if((state_val_18596 === (7))){
var inst_18591 = (state_18595[(2)]);
var state_18595__$1 = state_18595;
var statearr_18597_18635 = state_18595__$1;
(statearr_18597_18635[(2)] = inst_18591);

(statearr_18597_18635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (20))){
var inst_18561 = (state_18595[(7)]);
var inst_18572 = (state_18595[(2)]);
var inst_18573 = cljs.core.next.call(null,inst_18561);
var inst_18547 = inst_18573;
var inst_18548 = null;
var inst_18549 = (0);
var inst_18550 = (0);
var state_18595__$1 = (function (){var statearr_18598 = state_18595;
(statearr_18598[(8)] = inst_18547);

(statearr_18598[(9)] = inst_18549);

(statearr_18598[(10)] = inst_18550);

(statearr_18598[(11)] = inst_18548);

(statearr_18598[(12)] = inst_18572);

return statearr_18598;
})();
var statearr_18599_18636 = state_18595__$1;
(statearr_18599_18636[(2)] = null);

(statearr_18599_18636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (1))){
var state_18595__$1 = state_18595;
var statearr_18600_18637 = state_18595__$1;
(statearr_18600_18637[(2)] = null);

(statearr_18600_18637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (4))){
var inst_18536 = (state_18595[(13)]);
var inst_18536__$1 = (state_18595[(2)]);
var inst_18537 = (inst_18536__$1 == null);
var state_18595__$1 = (function (){var statearr_18601 = state_18595;
(statearr_18601[(13)] = inst_18536__$1);

return statearr_18601;
})();
if(cljs.core.truth_(inst_18537)){
var statearr_18602_18638 = state_18595__$1;
(statearr_18602_18638[(1)] = (5));

} else {
var statearr_18603_18639 = state_18595__$1;
(statearr_18603_18639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (15))){
var state_18595__$1 = state_18595;
var statearr_18607_18640 = state_18595__$1;
(statearr_18607_18640[(2)] = null);

(statearr_18607_18640[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (21))){
var state_18595__$1 = state_18595;
var statearr_18608_18641 = state_18595__$1;
(statearr_18608_18641[(2)] = null);

(statearr_18608_18641[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (13))){
var inst_18547 = (state_18595[(8)]);
var inst_18549 = (state_18595[(9)]);
var inst_18550 = (state_18595[(10)]);
var inst_18548 = (state_18595[(11)]);
var inst_18557 = (state_18595[(2)]);
var inst_18558 = (inst_18550 + (1));
var tmp18604 = inst_18547;
var tmp18605 = inst_18549;
var tmp18606 = inst_18548;
var inst_18547__$1 = tmp18604;
var inst_18548__$1 = tmp18606;
var inst_18549__$1 = tmp18605;
var inst_18550__$1 = inst_18558;
var state_18595__$1 = (function (){var statearr_18609 = state_18595;
(statearr_18609[(8)] = inst_18547__$1);

(statearr_18609[(14)] = inst_18557);

(statearr_18609[(9)] = inst_18549__$1);

(statearr_18609[(10)] = inst_18550__$1);

(statearr_18609[(11)] = inst_18548__$1);

return statearr_18609;
})();
var statearr_18610_18642 = state_18595__$1;
(statearr_18610_18642[(2)] = null);

(statearr_18610_18642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (22))){
var state_18595__$1 = state_18595;
var statearr_18611_18643 = state_18595__$1;
(statearr_18611_18643[(2)] = null);

(statearr_18611_18643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (6))){
var inst_18536 = (state_18595[(13)]);
var inst_18545 = f.call(null,inst_18536);
var inst_18546 = cljs.core.seq.call(null,inst_18545);
var inst_18547 = inst_18546;
var inst_18548 = null;
var inst_18549 = (0);
var inst_18550 = (0);
var state_18595__$1 = (function (){var statearr_18612 = state_18595;
(statearr_18612[(8)] = inst_18547);

(statearr_18612[(9)] = inst_18549);

(statearr_18612[(10)] = inst_18550);

(statearr_18612[(11)] = inst_18548);

return statearr_18612;
})();
var statearr_18613_18644 = state_18595__$1;
(statearr_18613_18644[(2)] = null);

(statearr_18613_18644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (17))){
var inst_18561 = (state_18595[(7)]);
var inst_18565 = cljs.core.chunk_first.call(null,inst_18561);
var inst_18566 = cljs.core.chunk_rest.call(null,inst_18561);
var inst_18567 = cljs.core.count.call(null,inst_18565);
var inst_18547 = inst_18566;
var inst_18548 = inst_18565;
var inst_18549 = inst_18567;
var inst_18550 = (0);
var state_18595__$1 = (function (){var statearr_18614 = state_18595;
(statearr_18614[(8)] = inst_18547);

(statearr_18614[(9)] = inst_18549);

(statearr_18614[(10)] = inst_18550);

(statearr_18614[(11)] = inst_18548);

return statearr_18614;
})();
var statearr_18615_18645 = state_18595__$1;
(statearr_18615_18645[(2)] = null);

(statearr_18615_18645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (3))){
var inst_18593 = (state_18595[(2)]);
var state_18595__$1 = state_18595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18595__$1,inst_18593);
} else {
if((state_val_18596 === (12))){
var inst_18581 = (state_18595[(2)]);
var state_18595__$1 = state_18595;
var statearr_18616_18646 = state_18595__$1;
(statearr_18616_18646[(2)] = inst_18581);

(statearr_18616_18646[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (2))){
var state_18595__$1 = state_18595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18595__$1,(4),in$);
} else {
if((state_val_18596 === (23))){
var inst_18589 = (state_18595[(2)]);
var state_18595__$1 = state_18595;
var statearr_18617_18647 = state_18595__$1;
(statearr_18617_18647[(2)] = inst_18589);

(statearr_18617_18647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (19))){
var inst_18576 = (state_18595[(2)]);
var state_18595__$1 = state_18595;
var statearr_18618_18648 = state_18595__$1;
(statearr_18618_18648[(2)] = inst_18576);

(statearr_18618_18648[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (11))){
var inst_18547 = (state_18595[(8)]);
var inst_18561 = (state_18595[(7)]);
var inst_18561__$1 = cljs.core.seq.call(null,inst_18547);
var state_18595__$1 = (function (){var statearr_18619 = state_18595;
(statearr_18619[(7)] = inst_18561__$1);

return statearr_18619;
})();
if(inst_18561__$1){
var statearr_18620_18649 = state_18595__$1;
(statearr_18620_18649[(1)] = (14));

} else {
var statearr_18621_18650 = state_18595__$1;
(statearr_18621_18650[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (9))){
var inst_18583 = (state_18595[(2)]);
var inst_18584 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_18595__$1 = (function (){var statearr_18622 = state_18595;
(statearr_18622[(15)] = inst_18583);

return statearr_18622;
})();
if(cljs.core.truth_(inst_18584)){
var statearr_18623_18651 = state_18595__$1;
(statearr_18623_18651[(1)] = (21));

} else {
var statearr_18624_18652 = state_18595__$1;
(statearr_18624_18652[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (5))){
var inst_18539 = cljs.core.async.close_BANG_.call(null,out);
var state_18595__$1 = state_18595;
var statearr_18625_18653 = state_18595__$1;
(statearr_18625_18653[(2)] = inst_18539);

(statearr_18625_18653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (14))){
var inst_18561 = (state_18595[(7)]);
var inst_18563 = cljs.core.chunked_seq_QMARK_.call(null,inst_18561);
var state_18595__$1 = state_18595;
if(inst_18563){
var statearr_18626_18654 = state_18595__$1;
(statearr_18626_18654[(1)] = (17));

} else {
var statearr_18627_18655 = state_18595__$1;
(statearr_18627_18655[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (16))){
var inst_18579 = (state_18595[(2)]);
var state_18595__$1 = state_18595;
var statearr_18628_18656 = state_18595__$1;
(statearr_18628_18656[(2)] = inst_18579);

(statearr_18628_18656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18596 === (10))){
var inst_18550 = (state_18595[(10)]);
var inst_18548 = (state_18595[(11)]);
var inst_18555 = cljs.core._nth.call(null,inst_18548,inst_18550);
var state_18595__$1 = state_18595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18595__$1,(13),out,inst_18555);
} else {
if((state_val_18596 === (18))){
var inst_18561 = (state_18595[(7)]);
var inst_18570 = cljs.core.first.call(null,inst_18561);
var state_18595__$1 = state_18595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18595__$1,(20),out,inst_18570);
} else {
if((state_val_18596 === (8))){
var inst_18549 = (state_18595[(9)]);
var inst_18550 = (state_18595[(10)]);
var inst_18552 = (inst_18550 < inst_18549);
var inst_18553 = inst_18552;
var state_18595__$1 = state_18595;
if(cljs.core.truth_(inst_18553)){
var statearr_18629_18657 = state_18595__$1;
(statearr_18629_18657[(1)] = (10));

} else {
var statearr_18630_18658 = state_18595__$1;
(statearr_18630_18658[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto__))
;
return ((function (switch__16884__auto__,c__16979__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16885__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16885__auto____0 = (function (){
var statearr_18631 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18631[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16885__auto__);

(statearr_18631[(1)] = (1));

return statearr_18631;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16885__auto____1 = (function (state_18595){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18632){if((e18632 instanceof Object)){
var ex__16888__auto__ = e18632;
var statearr_18633_18659 = state_18595;
(statearr_18633_18659[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18632;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18660 = state_18595;
state_18595 = G__18660;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16885__auto__ = function(state_18595){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16885__auto____1.call(this,state_18595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16885__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16885__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto__))
})();
var state__16981__auto__ = (function (){var statearr_18634 = f__16980__auto__.call(null);
(statearr_18634[(6)] = c__16979__auto__);

return statearr_18634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto__))
);

return c__16979__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18662 = arguments.length;
switch (G__18662) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18665 = arguments.length;
switch (G__18665) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18668 = arguments.length;
switch (G__18668) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16979__auto___18715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18715,out){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18715,out){
return (function (state_18692){
var state_val_18693 = (state_18692[(1)]);
if((state_val_18693 === (7))){
var inst_18687 = (state_18692[(2)]);
var state_18692__$1 = state_18692;
var statearr_18694_18716 = state_18692__$1;
(statearr_18694_18716[(2)] = inst_18687);

(statearr_18694_18716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18693 === (1))){
var inst_18669 = null;
var state_18692__$1 = (function (){var statearr_18695 = state_18692;
(statearr_18695[(7)] = inst_18669);

return statearr_18695;
})();
var statearr_18696_18717 = state_18692__$1;
(statearr_18696_18717[(2)] = null);

(statearr_18696_18717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18693 === (4))){
var inst_18672 = (state_18692[(8)]);
var inst_18672__$1 = (state_18692[(2)]);
var inst_18673 = (inst_18672__$1 == null);
var inst_18674 = cljs.core.not.call(null,inst_18673);
var state_18692__$1 = (function (){var statearr_18697 = state_18692;
(statearr_18697[(8)] = inst_18672__$1);

return statearr_18697;
})();
if(inst_18674){
var statearr_18698_18718 = state_18692__$1;
(statearr_18698_18718[(1)] = (5));

} else {
var statearr_18699_18719 = state_18692__$1;
(statearr_18699_18719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18693 === (6))){
var state_18692__$1 = state_18692;
var statearr_18700_18720 = state_18692__$1;
(statearr_18700_18720[(2)] = null);

(statearr_18700_18720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18693 === (3))){
var inst_18689 = (state_18692[(2)]);
var inst_18690 = cljs.core.async.close_BANG_.call(null,out);
var state_18692__$1 = (function (){var statearr_18701 = state_18692;
(statearr_18701[(9)] = inst_18689);

return statearr_18701;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18692__$1,inst_18690);
} else {
if((state_val_18693 === (2))){
var state_18692__$1 = state_18692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18692__$1,(4),ch);
} else {
if((state_val_18693 === (11))){
var inst_18672 = (state_18692[(8)]);
var inst_18681 = (state_18692[(2)]);
var inst_18669 = inst_18672;
var state_18692__$1 = (function (){var statearr_18702 = state_18692;
(statearr_18702[(10)] = inst_18681);

(statearr_18702[(7)] = inst_18669);

return statearr_18702;
})();
var statearr_18703_18721 = state_18692__$1;
(statearr_18703_18721[(2)] = null);

(statearr_18703_18721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18693 === (9))){
var inst_18672 = (state_18692[(8)]);
var state_18692__$1 = state_18692;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18692__$1,(11),out,inst_18672);
} else {
if((state_val_18693 === (5))){
var inst_18672 = (state_18692[(8)]);
var inst_18669 = (state_18692[(7)]);
var inst_18676 = cljs.core._EQ_.call(null,inst_18672,inst_18669);
var state_18692__$1 = state_18692;
if(inst_18676){
var statearr_18705_18722 = state_18692__$1;
(statearr_18705_18722[(1)] = (8));

} else {
var statearr_18706_18723 = state_18692__$1;
(statearr_18706_18723[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18693 === (10))){
var inst_18684 = (state_18692[(2)]);
var state_18692__$1 = state_18692;
var statearr_18707_18724 = state_18692__$1;
(statearr_18707_18724[(2)] = inst_18684);

(statearr_18707_18724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18693 === (8))){
var inst_18669 = (state_18692[(7)]);
var tmp18704 = inst_18669;
var inst_18669__$1 = tmp18704;
var state_18692__$1 = (function (){var statearr_18708 = state_18692;
(statearr_18708[(7)] = inst_18669__$1);

return statearr_18708;
})();
var statearr_18709_18725 = state_18692__$1;
(statearr_18709_18725[(2)] = null);

(statearr_18709_18725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18715,out))
;
return ((function (switch__16884__auto__,c__16979__auto___18715,out){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18710 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18710[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18710[(1)] = (1));

return statearr_18710;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18692){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18711){if((e18711 instanceof Object)){
var ex__16888__auto__ = e18711;
var statearr_18712_18726 = state_18692;
(statearr_18712_18726[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18692);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18711;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18727 = state_18692;
state_18692 = G__18727;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18715,out))
})();
var state__16981__auto__ = (function (){var statearr_18713 = f__16980__auto__.call(null);
(statearr_18713[(6)] = c__16979__auto___18715);

return statearr_18713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18715,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18729 = arguments.length;
switch (G__18729) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16979__auto___18795 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18795,out){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18795,out){
return (function (state_18767){
var state_val_18768 = (state_18767[(1)]);
if((state_val_18768 === (7))){
var inst_18763 = (state_18767[(2)]);
var state_18767__$1 = state_18767;
var statearr_18769_18796 = state_18767__$1;
(statearr_18769_18796[(2)] = inst_18763);

(statearr_18769_18796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (1))){
var inst_18730 = (new Array(n));
var inst_18731 = inst_18730;
var inst_18732 = (0);
var state_18767__$1 = (function (){var statearr_18770 = state_18767;
(statearr_18770[(7)] = inst_18731);

(statearr_18770[(8)] = inst_18732);

return statearr_18770;
})();
var statearr_18771_18797 = state_18767__$1;
(statearr_18771_18797[(2)] = null);

(statearr_18771_18797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (4))){
var inst_18735 = (state_18767[(9)]);
var inst_18735__$1 = (state_18767[(2)]);
var inst_18736 = (inst_18735__$1 == null);
var inst_18737 = cljs.core.not.call(null,inst_18736);
var state_18767__$1 = (function (){var statearr_18772 = state_18767;
(statearr_18772[(9)] = inst_18735__$1);

return statearr_18772;
})();
if(inst_18737){
var statearr_18773_18798 = state_18767__$1;
(statearr_18773_18798[(1)] = (5));

} else {
var statearr_18774_18799 = state_18767__$1;
(statearr_18774_18799[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (15))){
var inst_18757 = (state_18767[(2)]);
var state_18767__$1 = state_18767;
var statearr_18775_18800 = state_18767__$1;
(statearr_18775_18800[(2)] = inst_18757);

(statearr_18775_18800[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (13))){
var state_18767__$1 = state_18767;
var statearr_18776_18801 = state_18767__$1;
(statearr_18776_18801[(2)] = null);

(statearr_18776_18801[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (6))){
var inst_18732 = (state_18767[(8)]);
var inst_18753 = (inst_18732 > (0));
var state_18767__$1 = state_18767;
if(cljs.core.truth_(inst_18753)){
var statearr_18777_18802 = state_18767__$1;
(statearr_18777_18802[(1)] = (12));

} else {
var statearr_18778_18803 = state_18767__$1;
(statearr_18778_18803[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (3))){
var inst_18765 = (state_18767[(2)]);
var state_18767__$1 = state_18767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18767__$1,inst_18765);
} else {
if((state_val_18768 === (12))){
var inst_18731 = (state_18767[(7)]);
var inst_18755 = cljs.core.vec.call(null,inst_18731);
var state_18767__$1 = state_18767;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18767__$1,(15),out,inst_18755);
} else {
if((state_val_18768 === (2))){
var state_18767__$1 = state_18767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18767__$1,(4),ch);
} else {
if((state_val_18768 === (11))){
var inst_18747 = (state_18767[(2)]);
var inst_18748 = (new Array(n));
var inst_18731 = inst_18748;
var inst_18732 = (0);
var state_18767__$1 = (function (){var statearr_18779 = state_18767;
(statearr_18779[(7)] = inst_18731);

(statearr_18779[(10)] = inst_18747);

(statearr_18779[(8)] = inst_18732);

return statearr_18779;
})();
var statearr_18780_18804 = state_18767__$1;
(statearr_18780_18804[(2)] = null);

(statearr_18780_18804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (9))){
var inst_18731 = (state_18767[(7)]);
var inst_18745 = cljs.core.vec.call(null,inst_18731);
var state_18767__$1 = state_18767;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18767__$1,(11),out,inst_18745);
} else {
if((state_val_18768 === (5))){
var inst_18731 = (state_18767[(7)]);
var inst_18735 = (state_18767[(9)]);
var inst_18732 = (state_18767[(8)]);
var inst_18740 = (state_18767[(11)]);
var inst_18739 = (inst_18731[inst_18732] = inst_18735);
var inst_18740__$1 = (inst_18732 + (1));
var inst_18741 = (inst_18740__$1 < n);
var state_18767__$1 = (function (){var statearr_18781 = state_18767;
(statearr_18781[(12)] = inst_18739);

(statearr_18781[(11)] = inst_18740__$1);

return statearr_18781;
})();
if(cljs.core.truth_(inst_18741)){
var statearr_18782_18805 = state_18767__$1;
(statearr_18782_18805[(1)] = (8));

} else {
var statearr_18783_18806 = state_18767__$1;
(statearr_18783_18806[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (14))){
var inst_18760 = (state_18767[(2)]);
var inst_18761 = cljs.core.async.close_BANG_.call(null,out);
var state_18767__$1 = (function (){var statearr_18785 = state_18767;
(statearr_18785[(13)] = inst_18760);

return statearr_18785;
})();
var statearr_18786_18807 = state_18767__$1;
(statearr_18786_18807[(2)] = inst_18761);

(statearr_18786_18807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (10))){
var inst_18751 = (state_18767[(2)]);
var state_18767__$1 = state_18767;
var statearr_18787_18808 = state_18767__$1;
(statearr_18787_18808[(2)] = inst_18751);

(statearr_18787_18808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18768 === (8))){
var inst_18731 = (state_18767[(7)]);
var inst_18740 = (state_18767[(11)]);
var tmp18784 = inst_18731;
var inst_18731__$1 = tmp18784;
var inst_18732 = inst_18740;
var state_18767__$1 = (function (){var statearr_18788 = state_18767;
(statearr_18788[(7)] = inst_18731__$1);

(statearr_18788[(8)] = inst_18732);

return statearr_18788;
})();
var statearr_18789_18809 = state_18767__$1;
(statearr_18789_18809[(2)] = null);

(statearr_18789_18809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18795,out))
;
return ((function (switch__16884__auto__,c__16979__auto___18795,out){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18790[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18790[(1)] = (1));

return statearr_18790;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18767){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18791){if((e18791 instanceof Object)){
var ex__16888__auto__ = e18791;
var statearr_18792_18810 = state_18767;
(statearr_18792_18810[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18811 = state_18767;
state_18767 = G__18811;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18767){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18795,out))
})();
var state__16981__auto__ = (function (){var statearr_18793 = f__16980__auto__.call(null);
(statearr_18793[(6)] = c__16979__auto___18795);

return statearr_18793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18795,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18813 = arguments.length;
switch (G__18813) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16979__auto___18883 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16979__auto___18883,out){
return (function (){
var f__16980__auto__ = (function (){var switch__16884__auto__ = ((function (c__16979__auto___18883,out){
return (function (state_18855){
var state_val_18856 = (state_18855[(1)]);
if((state_val_18856 === (7))){
var inst_18851 = (state_18855[(2)]);
var state_18855__$1 = state_18855;
var statearr_18857_18884 = state_18855__$1;
(statearr_18857_18884[(2)] = inst_18851);

(statearr_18857_18884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (1))){
var inst_18814 = [];
var inst_18815 = inst_18814;
var inst_18816 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_18855__$1 = (function (){var statearr_18858 = state_18855;
(statearr_18858[(7)] = inst_18815);

(statearr_18858[(8)] = inst_18816);

return statearr_18858;
})();
var statearr_18859_18885 = state_18855__$1;
(statearr_18859_18885[(2)] = null);

(statearr_18859_18885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (4))){
var inst_18819 = (state_18855[(9)]);
var inst_18819__$1 = (state_18855[(2)]);
var inst_18820 = (inst_18819__$1 == null);
var inst_18821 = cljs.core.not.call(null,inst_18820);
var state_18855__$1 = (function (){var statearr_18860 = state_18855;
(statearr_18860[(9)] = inst_18819__$1);

return statearr_18860;
})();
if(inst_18821){
var statearr_18861_18886 = state_18855__$1;
(statearr_18861_18886[(1)] = (5));

} else {
var statearr_18862_18887 = state_18855__$1;
(statearr_18862_18887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (15))){
var inst_18845 = (state_18855[(2)]);
var state_18855__$1 = state_18855;
var statearr_18863_18888 = state_18855__$1;
(statearr_18863_18888[(2)] = inst_18845);

(statearr_18863_18888[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (13))){
var state_18855__$1 = state_18855;
var statearr_18864_18889 = state_18855__$1;
(statearr_18864_18889[(2)] = null);

(statearr_18864_18889[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (6))){
var inst_18815 = (state_18855[(7)]);
var inst_18840 = inst_18815.length;
var inst_18841 = (inst_18840 > (0));
var state_18855__$1 = state_18855;
if(cljs.core.truth_(inst_18841)){
var statearr_18865_18890 = state_18855__$1;
(statearr_18865_18890[(1)] = (12));

} else {
var statearr_18866_18891 = state_18855__$1;
(statearr_18866_18891[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (3))){
var inst_18853 = (state_18855[(2)]);
var state_18855__$1 = state_18855;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18855__$1,inst_18853);
} else {
if((state_val_18856 === (12))){
var inst_18815 = (state_18855[(7)]);
var inst_18843 = cljs.core.vec.call(null,inst_18815);
var state_18855__$1 = state_18855;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18855__$1,(15),out,inst_18843);
} else {
if((state_val_18856 === (2))){
var state_18855__$1 = state_18855;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18855__$1,(4),ch);
} else {
if((state_val_18856 === (11))){
var inst_18823 = (state_18855[(10)]);
var inst_18819 = (state_18855[(9)]);
var inst_18833 = (state_18855[(2)]);
var inst_18834 = [];
var inst_18835 = inst_18834.push(inst_18819);
var inst_18815 = inst_18834;
var inst_18816 = inst_18823;
var state_18855__$1 = (function (){var statearr_18867 = state_18855;
(statearr_18867[(11)] = inst_18835);

(statearr_18867[(7)] = inst_18815);

(statearr_18867[(8)] = inst_18816);

(statearr_18867[(12)] = inst_18833);

return statearr_18867;
})();
var statearr_18868_18892 = state_18855__$1;
(statearr_18868_18892[(2)] = null);

(statearr_18868_18892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (9))){
var inst_18815 = (state_18855[(7)]);
var inst_18831 = cljs.core.vec.call(null,inst_18815);
var state_18855__$1 = state_18855;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18855__$1,(11),out,inst_18831);
} else {
if((state_val_18856 === (5))){
var inst_18823 = (state_18855[(10)]);
var inst_18816 = (state_18855[(8)]);
var inst_18819 = (state_18855[(9)]);
var inst_18823__$1 = f.call(null,inst_18819);
var inst_18824 = cljs.core._EQ_.call(null,inst_18823__$1,inst_18816);
var inst_18825 = cljs.core.keyword_identical_QMARK_.call(null,inst_18816,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_18826 = ((inst_18824) || (inst_18825));
var state_18855__$1 = (function (){var statearr_18869 = state_18855;
(statearr_18869[(10)] = inst_18823__$1);

return statearr_18869;
})();
if(cljs.core.truth_(inst_18826)){
var statearr_18870_18893 = state_18855__$1;
(statearr_18870_18893[(1)] = (8));

} else {
var statearr_18871_18894 = state_18855__$1;
(statearr_18871_18894[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (14))){
var inst_18848 = (state_18855[(2)]);
var inst_18849 = cljs.core.async.close_BANG_.call(null,out);
var state_18855__$1 = (function (){var statearr_18873 = state_18855;
(statearr_18873[(13)] = inst_18848);

return statearr_18873;
})();
var statearr_18874_18895 = state_18855__$1;
(statearr_18874_18895[(2)] = inst_18849);

(statearr_18874_18895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (10))){
var inst_18838 = (state_18855[(2)]);
var state_18855__$1 = state_18855;
var statearr_18875_18896 = state_18855__$1;
(statearr_18875_18896[(2)] = inst_18838);

(statearr_18875_18896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18856 === (8))){
var inst_18823 = (state_18855[(10)]);
var inst_18815 = (state_18855[(7)]);
var inst_18819 = (state_18855[(9)]);
var inst_18828 = inst_18815.push(inst_18819);
var tmp18872 = inst_18815;
var inst_18815__$1 = tmp18872;
var inst_18816 = inst_18823;
var state_18855__$1 = (function (){var statearr_18876 = state_18855;
(statearr_18876[(7)] = inst_18815__$1);

(statearr_18876[(8)] = inst_18816);

(statearr_18876[(14)] = inst_18828);

return statearr_18876;
})();
var statearr_18877_18897 = state_18855__$1;
(statearr_18877_18897[(2)] = null);

(statearr_18877_18897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16979__auto___18883,out))
;
return ((function (switch__16884__auto__,c__16979__auto___18883,out){
return (function() {
var cljs$core$async$state_machine__16885__auto__ = null;
var cljs$core$async$state_machine__16885__auto____0 = (function (){
var statearr_18878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18878[(0)] = cljs$core$async$state_machine__16885__auto__);

(statearr_18878[(1)] = (1));

return statearr_18878;
});
var cljs$core$async$state_machine__16885__auto____1 = (function (state_18855){
while(true){
var ret_value__16886__auto__ = (function (){try{while(true){
var result__16887__auto__ = switch__16884__auto__.call(null,state_18855);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16887__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16887__auto__;
}
break;
}
}catch (e18879){if((e18879 instanceof Object)){
var ex__16888__auto__ = e18879;
var statearr_18880_18898 = state_18855;
(statearr_18880_18898[(5)] = ex__16888__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18855);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16886__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18899 = state_18855;
state_18855 = G__18899;
continue;
} else {
return ret_value__16886__auto__;
}
break;
}
});
cljs$core$async$state_machine__16885__auto__ = function(state_18855){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16885__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16885__auto____1.call(this,state_18855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16885__auto____0;
cljs$core$async$state_machine__16885__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16885__auto____1;
return cljs$core$async$state_machine__16885__auto__;
})()
;})(switch__16884__auto__,c__16979__auto___18883,out))
})();
var state__16981__auto__ = (function (){var statearr_18881 = f__16980__auto__.call(null);
(statearr_18881[(6)] = c__16979__auto___18883);

return statearr_18881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16981__auto__);
});})(c__16979__auto___18883,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
