// Compiled by ClojureScript 1.10.520 {}
goog.provide('hx_comp.core');
goog.require('cljs.core');
goog.require('goog.color');
goog.require('goog.object');
goog.require('jss');
goog.require('jss_preset_default');
goog.require('hx_comp.styles.borders');
goog.require('hx_comp.styles.media_queries');
goog.require('hx_comp.styles.radius');
goog.require('hx_comp.styles.resets');
goog.require('hx_comp.styles.shadows');
goog.require('hx_comp.styles.spacing');
goog.require('hx_comp.styles.typography');
hx_comp.core.global$module$jss = goog.global["jss"];
hx_comp.core.global$module$jss_preset_default = goog.global["jssPresetDefault"];

/** @define {string} */
goog.define("hx_comp.core.primary_color","#76ae47");

/** @define {string} */
goog.define("hx_comp.core.secondary_color","#5d82d2");

/** @define {string} */
goog.define("hx_comp.core.primary_font","'Open Sans', sans-serif");

/** @define {string} */
goog.define("hx_comp.core.secondary_font","'Roboto Mono', monospace");
cljs.core.js_invoke.call(null,hx_comp.core.global$module$jss,"setup",hx_comp.core.global$module$jss_preset_default.call(null));
hx_comp.core.global_styles = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
hx_comp.core.adjust_color = (function hx_comp$core$adjust_color(adjustment_fn,color_value,factor){
return goog.color.rgbArrayToHex(adjustment_fn.call(null,goog.color.hexToRgb(color_value),factor));
});
hx_comp.core.lighten = cljs.core.partial.call(null,hx_comp.core.adjust_color,goog.color.lighten);
hx_comp.core.darken = cljs.core.partial.call(null,hx_comp.core.adjust_color,goog.color.darken);
hx_comp.core.styles__GT_classes = (function hx_comp$core$styles__GT_classes(styles){
return cljs.core.js__GT_clj.call(null,goog.object.get(cljs.core.js_invoke.call(null,cljs.core.js_invoke.call(null,hx_comp.core.global$module$jss,"createStyleSheet",cljs.core.clj__GT_js.call(null,styles)),"attach"),"classes"),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
hx_comp.core.create_color_scale = (function hx_comp$core$create_color_scale(p__13842){
var map__13843 = p__13842;
var map__13843__$1 = (((((!((map__13843 == null))))?(((((map__13843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13843.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13843):map__13843);
var color_name = cljs.core.get.call(null,map__13843__$1,new cljs.core.Keyword(null,"color-name","color-name",-795246340));
var color_value = cljs.core.get.call(null,map__13843__$1,new cljs.core.Keyword(null,"color-value","color-value",1651973425));
if(cljs.core.truth_(goog.color.isValidColor(color_value))){
var scale__GT_name = ((function (map__13843,map__13843__$1,color_name,color_value){
return (function hx_comp$core$create_color_scale_$_scale__GT_name(scale){
return cljs.core.keyword.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(color_name),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scale)].join(''));
});})(map__13843,map__13843__$1,color_name,color_value))
;
return cljs.core.PersistentHashMap.fromArrays([scale__GT_name.call(null,"1000"),scale__GT_name.call(null,"800"),scale__GT_name.call(null,"700"),scale__GT_name.call(null,"900"),scale__GT_name.call(null,"200"),scale__GT_name.call(null,"100"),scale__GT_name.call(null,"300"),scale__GT_name.call(null,"50"),scale__GT_name.call(null,"600"),scale__GT_name.call(null,"500"),scale__GT_name.call(null,"400")],[hx_comp.core.darken.call(null,color_value,0.5),hx_comp.core.darken.call(null,color_value,0.3),hx_comp.core.darken.call(null,color_value,0.2),hx_comp.core.darken.call(null,color_value,0.4),hx_comp.core.lighten.call(null,color_value,0.3),hx_comp.core.lighten.call(null,color_value,0.4),hx_comp.core.lighten.call(null,color_value,0.2),hx_comp.core.lighten.call(null,color_value,0.5),hx_comp.core.darken.call(null,color_value,0.1),color_value,hx_comp.core.lighten.call(null,color_value,0.1)]);
} else {
console.error(["Color not valid: '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(color_value),"'"].join(''));

return cljs.core.PersistentArrayMap.EMPTY;
}
});
hx_comp.core.colors = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"true-white","true-white",-175962977),"#FFFFFF",new cljs.core.Keyword(null,"true-black","true-black",220386711),"#FFFFFF"], null),hx_comp.core.create_color_scale.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color-name","color-name",-795246340),"primary",new cljs.core.Keyword(null,"color-value","color-value",1651973425),hx_comp.core.primary_color], null)),hx_comp.core.create_color_scale.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color-name","color-name",-795246340),"secondary",new cljs.core.Keyword(null,"color-value","color-value",1651973425),hx_comp.core.secondary_color], null)),hx_comp.core.create_color_scale.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color-name","color-name",-795246340),"gray-scale",new cljs.core.Keyword(null,"color-value","color-value",1651973425),"#717171"], null)));
cljs.core.reset_BANG_.call(null,hx_comp.core.global_styles,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"font-height","font-height",49078273),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"shadows","shadows",-1489088471),new cljs.core.Keyword(null,"colors","colors",1157174732),new cljs.core.Keyword(null,"radius","radius",-2073122258),new cljs.core.Keyword(null,"borders","borders",-2120100848),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"spacing","spacing",204422175)],[hx_comp.styles.typography.line_height,hx_comp.styles.typography.size,hx_comp.styles.typography.weight,hx_comp.styles.shadows.shadows,hx_comp.core.colors,hx_comp.styles.radius.radius,hx_comp.styles.borders.borders.call(null,hx_comp.core.colors),hx_comp.styles.media_queries.queries,hx_comp.styles.typography.font_families.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary-font","primary-font",-447138623),hx_comp.core.primary_font,new cljs.core.Keyword(null,"secondary-font","secondary-font",-1501015376),hx_comp.core.secondary_font], null)),hx_comp.styles.spacing.spacing]));
hx_comp.core.styles__GT_classes.call(null,new cljs.core.PersistentArrayMap(null, 1, ["@global",hx_comp.styles.resets.resets], null));
/**
 * Pulls a styles from global-styles. If no style exists in the style
 *   map, and error will bre returned.
 */
hx_comp.core.gs = (function hx_comp$core$gs(lens){
var style = cljs.core.get_in.call(null,cljs.core.deref.call(null,hx_comp.core.global_styles),lens,(new Error(({"message": "Style not found", "data": lens}))));
if(cljs.core._EQ_.call(null,cljs.core.type.call(null,style),Error)){
return console.error(style,lens);
} else {
return style;
}
});
hx_comp.core.create_font_styles = (function hx_comp$core$create_font_styles(p__13845){
var map__13846 = p__13845;
var map__13846__$1 = (((((!((map__13846 == null))))?(((((map__13846.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13846.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13846):map__13846);
var style = cljs.core.get.call(null,map__13846__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var color = cljs.core.get.call(null,map__13846__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var family = cljs.core.get.call(null,map__13846__$1,new cljs.core.Keyword(null,"family","family",-1313145692));
return cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"-webkit-text-size-adjust","-webkit-text-size-adjust",827099523),new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),style], null)),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),style], null)),new cljs.core.Keyword(null,"line-height","line-height",1870784992),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"font-height","font-height",49078273),style], null)),new cljs.core.Keyword(null,"color","color",1011675173),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"colors","colors",1157174732),color], null)),new cljs.core.Keyword(null,"font-family","font-family",-667419874),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"font-family","font-family",-667419874),family], null)),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"tablet","tablet",-318585919)], null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),cljs.core.keyword.call(null,cljs.core.name.call(null,style),"tablet")], null))], null),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"phone","phone",-763596057)], null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),hx_comp.core.gs.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),cljs.core.keyword.call(null,cljs.core.name.call(null,style),"mobile")], null))], null)]);
});
hx_comp.core.update_class_value = (function hx_comp$core$update_class_value(class_name,c){
if((c == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [class_name], null);
} else {
if(cljs.core.vector_QMARK_.call(null,c)){
return cljs.core.conj.call(null,c,class_name);
} else {
if(typeof c === 'string'){
return [c," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name)].join('');
} else {
return console.error(["Invalid class definition: '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name),"'"].join(''));

}
}
}
});
/**
 * Adds a class to an elements options hash
 */
hx_comp.core.add_class = (function hx_comp$core$add_class(options,class_key,class_map){
var class_name = goog.object.get(cljs.core.clj__GT_js.call(null,class_map),cljs.core.name.call(null,class_key));
if((!((class_name == null)))){
} else {
console.error(["Class not found: '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_key),"'"].join(''));
}

return cljs.core.update.call(null,options,new cljs.core.Keyword(null,"class","class",-2030961996),cljs.core.partial.call(null,hx_comp.core.update_class_value,class_name));
});

//# sourceMappingURL=core.js.map
