(ns obis-shared.shibboleth
  (:use obis-shared.utils.gen-class)
  (:require [obis-shared.entity :as ent]
            [obis-shared.entity.simple :as simple]))

(defn named-or-str
  [x]
  (if (instance? clojure.lang.Named x)
    (name x)
    (str x)))

(defn- lowercase-str-keys
  [m]
  (zipmap
    (for [k (keys m)] (.toLowerCase (named-or-str k)))
    (vals m)))

(defn headers-to-uid
  [m]
  (let [{remote-user "remote_user", :strs [uid]} (lowercase-str-keys m)]
    (or uid
        (if remote-user
          (if-let [[_ email-prefix] (re-matches #"([^@]+)@.*" remote-user)]
            email-prefix)))))

(defn headers-to-identity
  "Takes a Map<String, String> of Shibboleth request headers
  and returns an entity map or nil."
  [m]
  (if-let [uid (headers-to-uid m)]
    (try
      (let [ent (ent/find-entity-by-identifier "ldap_uid" uid)]
        (-> ent :identifiers :OBISID simple/get-entity))
      ; if 404, swallow and return nil. Maybe we should be changing
      ; some of the other functions so there's no exception to catch.
      (catch Exception e
        (when-not (re-find #"404" (.getMessage e))
          (throw e))))))

(gen-class-with-exports)
