(ns obis-shared.entity.organizations
  (:use obis-shared.utils.gen-class)
  (:require [obis-shared.entity.http-json :as http]
            [clojure.walk :as walk]
            [obis-shared.entity.utils :as u]))

;;TODO: 
;; This is entirely pojecterish but it is what it is
;; until we assign permanent-ids to organizational
;; units.
(def ctrc-obis-id "87d1220c5abf9f9608121672be0e3ac1")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This will enable the generic walking of the
;; organization tree. Eventually. Some day.
;; Maybe.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def levels [{:name "institutions"}
             {:name "providers"
              :parent-id :institution_id}
             {:name "programs"
              :parent-id :provider_id}
             {:name "cores"
              :parent-id :program_id}])

(defn level-name
  [level]
  (:name level))

(defn parent-id
  [level]
  (:parent-id level))

(defn descend-from
  [name]
  (reverse (take-while #(not= (level-name %) name)
                       (reverse levels))))

(defn ascend-from
  [name]
  (reverse (take-while #(not= (level-name %) name)
                       levels)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; CRUD FUNCTIONS FOR ORGANIZATIONS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;TODO: CREATE
;;TODO: UPDATE
;;TODO: DELETE

;; READ

(defn fetch-organizations-at-level
  [level]
  (http/get-simple [(level-name level)]))

(defn fetch-cores
  []
  (fetch-organizations-at-level (last levels)))

(defn fetch-programs
  []
  (fetch-organizations-at-level (nth levels 2)))

(defn fetch-providers
  []
  (fetch-organizations-at-level (second levels)))

(defn fetch-institutions
  []
  (fetch-organizations-at-level (first levels)))

(defn fetch-all
  []
  {:cores (fetch-cores)
   :providers (fetch-providers)
   :programs (fetch-programs)
   :institutions (fetch-institutions)})

(defn organization
  [id]
  (http/get-simple ["organizational_units" id]))

(defn relationships
  [org-id]
  (http/get ["organizational_units" org-id "relationships"]))

(defn relationships-by-type
  [org-id relationship-type]
  (let [r (relationships org-id)]
    (filter #(= (:relationship_type %) relationship-type) r)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ORGANIZATIONAL MAP
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;TODO: Genericize this to use the information from the level
;;functions above.
;;TODO: Use a group-by so a list of organizations is only cycled
;;through once.
;;TODO: Only a poject could love this.
(defn add-providers-to-institution
  [institution providers]
  (let [associated-providers (u/filter-by :institution_id (:id institution) providers )]
    (assoc institution :providers associated-providers )))

(defn add-providers-to-institutions
  [providers institutions]
  (doall (map #(add-providers-to-institution % providers) institutions)))

(defn add-programs-to-provider
  [provider programs]
  (let [associated-programs (u/filter-by :provider_id (:id provider) programs)]
    (assoc provider :programs associated-programs )))

(defn add-programs-to-providers
  [programs providers]
  (doall
   (map #(add-programs-to-provider % programs) providers)))

(defn add-cores-to-program
  [program cores]
  (let [associated-cores (u/filter-by :program_id (:id program) cores)]
    (assoc program :cores associated-cores)))

(defn add-cores-to-programs
  [cores programs]
  (doall
   (map #(add-cores-to-program % cores) programs)))

;; TODO: POJECT
(defn build-organization-map
  []
  (let [all-organizations (fetch-all)]
    (-> (add-cores-to-programs (:cores all-organizations)
                               (:programs all-organizations))
        (add-programs-to-providers (:providers all-organizations))
        (add-providers-to-institutions (:institutions all-organizations)))))

(defn organization-ids
  [org-map]
  (let [ids (atom [])]
    (walk/postwalk
     (fn [node]
       (if (:id node)
         (reset! ids (conj @ids (:id node))))
       node)
     org-map)
    @ids))

;;TODO: Only a poject could love this.
(defn search-by-id 
  [organization-map id]
  (let [match (atom nil)]
    (clojure.walk/postwalk
     (fn [node]
       (if (= id (:id node))
         (do
           (reset! match node)
            node)
         node))
     organization-map)
    @match))

(defn all-related-organizations
  [org-map identity]
  (organization-ids (search-by-id org-map identity)))

(defn ctrc-and-descendants
  [org-map]
  (set (all-related-organizations org-map ctrc-obis-id)))

(gen-class-with-exports)
