(ns {{namespace}}
  (:gen-class)
  (:require [com.stuartsierra.component :as component]
            [taoensso.timbre :as log]
            [{{name}}.system :as system]))



(defn -main [& args]
  (if-let [config-path (first args)]
    (do
      (log/info "Starting {{name}} with config:" config-path)
      (-> config-path
          system/read-config
          system/new-system
          component/start)
      (shutdown-agents))
    (do
      (log/error "Usage: java <jar-path> <config-file-path>")
      (System/exit 1))))
