(ns leiningen.new.oaklabs-app
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files
                                             multi-segment sanitize-ns]]
            [leiningen.core.main :as main]))

(def render (renderer "oaklabs-app"))

(defn oaklabs-app
  "FIXME: write documentation"
  [name]
  (let [main-ns (multi-segment (sanitize-ns name))
        data {:name name
              :namespace main-ns
              :container (str "us.gcr.io/oak-backend/" name)
              :k8s-configmap (str name "-config")
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' oaklabs-app project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/system.clj" (render "system.clj" data)]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["config.edn" (render "config.edn" data)]
             ["dev/user.clj" (render "user.clj" data)]
             ["deployment.yml" (render "deployment.yml" data)]
             ["job.yml" (render "job.yml" data)]
             ["README.md" (render "README.md" data)])))
