(ns {{name}}.core
    (:require
     [re-frame.core :as rf]
     [reagent.core :as r]
     [{{name}}.routes :as routes]
     [{{name}}.views :as views]
     [{{name}}.handlers]
     [{{name}}.subs]))

(enable-console-print!)

(defn mount-root []
  (r/render [views/main-panel]
    (.getElementById js/document "app")))


(defn ^:export init []
  (rf/dispatch-sync [:initialize-db])
  (routes/app-routes)
  (mount-root))
