(ns {{name}}.system
    (:require
     [com.stuartsierra.component :as component]
     (ring.middleware
       [reload :refer [wrap-reload]]
       [refresh :refer [wrap-refresh]])
     (system.components
       [jetty :refer [new-web-server]]
       [handler :refer [new-handler]]
       [hikari :refer [new-hikari-cp]]
       [middleware :refer [new-middleware]])
     [{{name}}.handler :as handler]))


(def db-config {:adapter       "postgresql"
                :server-name   "localhost"
                :database-name "{{name}}"
                :username      "{{name}}"
                :password      ""})

(defn prod-system []
  (-> (component/map->SystemMap
        {:http       (new-web-server 3000)
         ;;:db         (new-hikari-cp db-config)
         :middleware (new-middleware {:middleware []})
         :handler    (new-handler)
         :app-routes (new-endpoint handler/app)
         })

    (component/system-using
      {:handler [:app-routes :middleware]
       :http    [:handler]
       })))


(defn dev-system []
  (assoc (prod-system)
    :middleware (new-middleware {:middleware [[wrap-refresh]
                                              [wrap-reload]]}))

(comment
  (set-init! #'dev-system)
  (start)
  (stop)

  )
