(ns {{name}}.handler
    (:require
     [ring.middleware.params :refer  [wrap-params]]
     [ring.middleware.defaults :refer [wrap-defaults site-defaults]]
     [ring.middleware.resource :refer [wrap-resource]]
     [ring.middleware.file :refer [wrap-file]]
     [ring.middleware.content-type :refer [wrap-content-type]]
     [ring.middleware.not-modified :refer [wrap-not-modified]]
     [compojure.core :refer [defroutes ANY GET]]
     [hiccup.middleware :refer [wrap-base-url]]
     [{{name}}.layout :as layout]
     ))



(defn home [req]
  (layout/common
    [:h1 "Hello world! {{name}}"]))


(defroutes web
  (GET "/" [] home))

(defroutes app-routes
  web)

(def app
  (-> app-routes
    (wrap-defaults (assoc-in site-defaults
                     [:security :anti-forgery] false))
    (wrap-content-type)
    (wrap-not-modified)
    (wrap-base-url)))
