(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.9.0-alpha11"]
                 [org.clojure/clojurescript "1.9.225"]
                 [org.clojure/core.async "0.2.385"]

                 {{#clj}}
                 ;; Ring
                 [compojure "1.5.1"]
                 [ring "1.5.0"]
                 [ring/ring-defaults "0.2.1"]
                 [ring-refresh "0.1.1"]
                 [hiccup "1.0.5"]

                 ;; Db
                 [org.clojure/java.jdbc "0.6.1"]
                 [honeysql "0.8.0"]
                 [hikari-cp "1.7.3"]

                 ;; Log
                 [com.taoensso/timbre "4.7.3"]
                 [org.slf4j/slf4j-nop "1.7.19"]

                 ;; Components
                 [org.danielsz/system "0.3.2-SNAPSHOT" :exclusions [org.clojure/tools.namespace]]
                 {{/clj}}

                 {{#cljs}}
                 ;; Reagent
                 [reagent "0.6.0-rc"]
                 [reagent-utils "0.1.9"]
                 [re-frame "0.7.0"]

                 ;; Routes
                 [secretary "1.2.3"]
                 [venantius/accountant "0.1.7"]
                 {{/cljs}}

                 ]

  :plugins [[lein-cljsbuild "1.1.3"]
            {{#sass}}[lein-sassy "1.0.7"]{{/sass}}
            [lein-pdo "0.1.1"]]

  :source-paths [{{#clj}}"src/clj"{{/clj}}
                 {{#cljs}}"src/cljs"{{/cljs}}
                 "src/cljc"]

  :test-paths ["test/clj" "test/cljc"]
  :clean-targets ^{:protect false} [:target-path :compile-path "resources/public/js"]

  :uberjar-name "{{name}}.jar"
  :main {{name}}.core

  {{#cljs}}
  :cljsbuild {:builds
              [{:id           "app"
                :source-paths ["src/cljs" "src/cljc"]

                :figwheel true
                ;; Alternatively, you can configure a function to run every time figwheel reloads.
                ;; :figwheel {:on-jsload "{{name}}.core/on-figwheel-reload"}

                :compiler {:main                 "{{name}}.core"
                           :asset-path           "js/compiled/out"
                           :output-to            "resources/public/js/compiled/{{name}}.js"
                           :output-dir           "resources/public/js/compiled/out"
                           :source-map-timestamp true}}

               {:id           "test"
                :source-paths ["src/cljs" "test/cljs" "src/cljc" "test/cljc"]
                :compiler     {:output-to     "resources/public/js/compiled/testable.js"
                               :main          "{{name}}.test-runner"
                               :optimizations :none}}

               {:id           "min"
                :source-paths ["src/cljs" "src/cljc"]
                :jar          true
                :compiler     {:main                 "{{name}}.core"
                               :output-to            "resources/public/js/compiled/{{name}}.js"
                               :output-dir           "target"
                               :source-map-timestamp true
                               :optimizations        :advanced
                               :pretty-print         false}}]}


  :figwheel {:nrepl-port       7888
             :nrepl-middleware ["cider.nrepl/cider-middleware"
                                "refactor-nrepl.middleware/wrap-refactor"
                                "cemerick.piggieback/wrap-cljs-repl"]
             :css-dirs         ["resources/public/css/"]

             ;; Instead of booting a separate server on its own port, we embed
             ;; the server ring handler inside figwheel's http-kit server, so
             ;; assets and API endpoints can all be accessed on the same host
             ;; and port. If you prefer a separate server process then take this
             ;; out and start the server with `lein run`.
             ;;:ring-handler      user/http-handler
             :open-file-command "myfile-opener"
             :server-logfile    "log/figwheel.log"
             }
  {{/cljs}}

  :aliases {"dev"  ["pdo" ["figwheel"] {{#sass}}["sass" "watch"]{{/sass}}]
            "prod" ["do" "clean"
                    ["pdo" {{#sass}}["sass" "once"]{{/sass}} ["cljsbuild" "once" "min"]]]}
  {{#sass}}
  :sass {:src   "src/scss/"
         :dst   "resources/public/css/"
         :style :compressed}
  {{/sass}}

  :profiles {:dev
             {:dependencies [[figwheel "0.5.4-4"]
                             [figwheel-sidecar "0.5.4-4"]
                             [com.cemerick/piggieback "0.2.1"]
                             [org.clojure/tools.nrepl "0.2.12"]
                             [refactor-nrepl "2.2.0"]
                             [cider/cider-nrepl "0.11.0"]]

              :plugins [[lein-figwheel "0.5.4-4"]
                        [lein-doo "0.1.6"]]

              :source-paths ["dev"]
              :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}

             :uberjar
             {:source-paths ^:replace ["src/clj" "src/cljc"]
              {{#cljs}}
              :prep-tasks   ["compile" ["cljsbuild" "once" "min"]]
              {{/cljs}}
              :hooks        [{{#sass}}leiningen.sass{{/sass}}]
              :omit-source  true
              :aot          :all}}
  )
