(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.9.0-alpha11"]
                 [org.clojure/clojurescript "1.9.225"]
                 [org.clojure/core.async "0.2.385"]

                 ;; ;; Reagent
                 ;; [reagent "0.6.0-rc"]
                 ;; [reagent-utils "0.1.9"]
                 ;; [re-frame "0.7.0"]

                 ;; ;; Routes
                 ;; [secretary "1.2.3"]
                 ;; [venantius/accountant "0.1.7"]


                 ]

  :plugins [[lein-cljsbuild "1.1.3"]
            [lein-figwheel "0.5.4-5"]
            [lein-sassy "1.0.7"]
            [lein-resource "15.10.2"]
            [refactor-nrepl "2.2.0"]
            [cider/cider-nrepl "0.11.0"]
            [lein-pdo "0.1.1"]]

  :profiles {:dev {:dependencies [[com.cemerick/piggieback "0.2.1"]
                                  [figwheel-sidecar "0.5.4-5"]]}}

  :clean-targets ^{:protect false} ["resources/public/static/frontend/js/"
                                    "apps/vendormatch/static/frontend/js/"]
  :cljsbuild {:test-commands
              ;; Test command for running the unit tests in "test-cljs" (see below).
              ;;     $ lein cljsbuild test
              {"unit" ["phantomjs"
                       "phantom/unit-test.js"
                       "resources/private/html/unit-test.html"]}
              :builds
              [{:id           "dev"
                :source-paths ["src"]
                :figwheel     {:on-jsload "{{name}}.app/mount-root"}
                :compiler     {:main       "{{name}}.core"
                               :output-to  "apps/vendormatch/static/frontend/js/app.js"
                               :output-dir "apps/vendormatch/static/frontend/js/"
                               :asset-path "/static/frontend/js/"

                               :optimizations        :none
                               :source-map-timestamp true
                               :parallel-build       true}}

               {:id           "test"
                :source-paths ["src" "test"]
                :compiler     {:output-to      "resources/private/js/unit-test.js"
                               :optimizations  :none
                               :parallel-build true}}

               {:id           "min"
                :source-paths ["src"]
                :compiler     {:main       "{{name}}.core"
                               :output-to  "apps/vendormatch/static/frontend/js/app.js"
                               :output-dir "apps/vendormatch/static/frontend/js/min/"

                               :optimizations    :advanced
                               :parallel-build   true
                               :externs          []
                               :closure-defines  {goog.DEBUG false}
                               ;;:pseudo-names     true
                               :closure-warnings {:externs-validation :off}
                               :pretty-print     false
                               ;;:source-map-timestamp true
                               :source-map       "apps/vendormatch/static/frontend/js/app.js.map"

                               }}]}



  :figwheel {:nrepl-port       7888
             :nrepl-middleware ["cider.nrepl/cider-middleware"
                                "refactor-nrepl.middleware/wrap-refactor"
                                "cemerick.piggieback/wrap-cljs-repl"]
             :css-dirs         ["apps/vendormatch/static/frontend/css/"]}


  :aliases {"dev"  ["pdo" ["figwheel"] ["sass" "watch"]]
            "prod" ["do" "clean"
                    ["pdo" ["sass" "once"] ["cljsbuild" "once" "min"]]
                    ]}

  :sass {:src   "resources/scss/"
         :dst   "apps/vendormatch/static/frontend/css/"
         :style :compressed}
  )
